/*
 * Decompiled with CFR 0.152.
 */
package speeth.output.parsegui;

import java.io.IOException;
import java.util.ArrayList;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import speeth.input.grammarfile.VoxGrammarLexer;
import speeth.input.grammarfile.VoxGrammarParser;
import speeth.lang.AnalysisException;
import speeth.lang.GrammarFileException;
import speeth.lang.LangDB;
import speeth.output.parsegui.LayoutTree;
import speeth.parser.SentenceAnalyser;
import speeth.parser.SynTree;

public class ParseString {
    private LangDB mGramDescr;
    private String mWarnings = "";

    public ParseString(String gramFile) throws IOException {
        this.loadGrammarFromFile(gramFile);
    }

    private void loadGrammarFromFile(String gramfile) throws IOException {
        ANTLRFileStream input = new ANTLRFileStream(gramfile);
        VoxGrammarLexer lexer = new VoxGrammarLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        VoxGrammarParser parser = new VoxGrammarParser(tokens);
        try {
            this.mGramDescr = parser.file();
        }
        catch (RecognitionException e) {
            new RuntimeException("Parsing caused RecognitionException. That should not happen.", e);
        }
    }

    public ArrayList<LayoutTree> parse(String sentence, String cons) throws GrammarFileException, IOException, AnalysisException {
        SentenceAnalyser sana = this.mGramDescr.createSentenceAnalyser();
        StringBuffer msg = new StringBuffer();
        boolean isok = sana.check(msg);
        if (!(isok &= this.mGramDescr.getTLR("mophon").check(msg))) {
            throw new GrammarFileException(-1, msg.toString());
        }
        this.mWarnings = msg.toString();
        Iterable<SynTree> result = sana.analyse(cons, sentence);
        ArrayList<LayoutTree> layoutTreeList = new ArrayList<LayoutTree>();
        for (SynTree s : result) {
            layoutTreeList.add(new LayoutTree(s, this.mGramDescr.getTLR("mophon")));
        }
        return layoutTreeList;
    }

    public String getWarnings() {
        return this.mWarnings;
    }
}

