/*
 * Decompiled with CFR 0.152.
 */
package speeth.output.parsegui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.plaf.metal.MetalIconFactory;
import speeth.lang.GrammarFileException;
import speeth.output.parsegui.LayoutTree;
import speeth.output.parsegui.ParseString;
import speeth.output.parsegui.TreeJPanel;

public class Gui
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 222222222L;
    private JTextField mFileTextField = new JTextField();
    private JComboBox mPhraseTextField = new JComboBox();
    private JComboBox mConstituentField = new JComboBox();
    private JButton mFindButton;
    private JButton mFileButton;
    private JPanel mscrollPanel;
    final JFileChooser mFileChooser = new JFileChooser(".");
    private JTextArea mMessageField;

    public Gui() {
        this.mFindButton = new JButton("Parse");
        this.mFindButton.addActionListener(this);
        this.mFileButton = new JButton(MetalIconFactory.getTreeFloppyDriveIcon());
        this.mFileButton.addActionListener(this);
        this.mPhraseTextField.setEditable(true);
        this.mPhraseTextField.addActionListener(this);
        this.mConstituentField.addItem("S");
        this.mConstituentField.setPreferredSize(new Dimension(80, this.mConstituentField.getSize().height));
        this.mConstituentField.addActionListener(this);
        this.mConstituentField.setEditable(true);
        this.mscrollPanel = new JPanel();
        this.mscrollPanel.setLayout(new BoxLayout(this.mscrollPanel, 3));
        JScrollPane scrollPane = new JScrollPane(this.mscrollPanel);
        scrollPane.setPreferredSize(new Dimension(800, 500));
        scrollPane.setAutoscrolls(true);
        Container pane = this.getContentPane();
        pane.setLayout(new BoxLayout(pane, 3));
        JPanel filepanel = new JPanel();
        filepanel.setLayout(new BoxLayout(filepanel, 2));
        filepanel.add(new JLabel("Grammar file: "));
        filepanel.add(this.mFileTextField);
        filepanel.add(this.mFileButton);
        filepanel.add(Box.createHorizontalStrut(5));
        filepanel.add(new JLabel("Constituent: "));
        filepanel.add(this.mConstituentField);
        filepanel.setMaximumSize(new Dimension(Short.MAX_VALUE, filepanel.getHeight()));
        pane.add(filepanel);
        pane.add(Box.createVerticalStrut(3));
        JPanel phrasepanel = new JPanel();
        phrasepanel.setLayout(new BoxLayout(phrasepanel, 2));
        phrasepanel.add(new JLabel("Phrase: "));
        phrasepanel.add(this.mPhraseTextField);
        phrasepanel.add(Box.createHorizontalStrut(10));
        phrasepanel.add(this.mFindButton);
        phrasepanel.setMaximumSize(new Dimension(Short.MAX_VALUE, phrasepanel.getHeight()));
        pane.add(phrasepanel);
        pane.add(Box.createVerticalStrut(3));
        JSeparator sep = new JSeparator();
        sep.setMaximumSize(new Dimension(Short.MAX_VALUE, sep.getHeight()));
        pane.add(sep);
        pane.add(scrollPane);
        sep = new JSeparator();
        sep.setMaximumSize(new Dimension(Short.MAX_VALUE, sep.getHeight()));
        this.add(sep);
        this.mMessageField = new JTextArea("");
        this.mMessageField.setEditable(false);
        this.mMessageField.setFont(new Font("SansSerif", 1, 12));
        this.mMessageField.setMaximumSize(new Dimension(Short.MAX_VALUE, 0));
        this.mMessageField.setPreferredSize(new Dimension(this.mMessageField.getWidth(), 0));
        this.add(this.mMessageField);
        this.setTitle("Grammar Parser");
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object newphrase = this.mConstituentField.getSelectedItem();
        Object newtext = this.mPhraseTextField.getSelectedItem();
        if (e.getSource() == this.mConstituentField) {
            if (newphrase == null || newphrase.toString().isEmpty()) {
                return;
            }
            if (this.mConstituentField.getSelectedIndex() < 0) {
                this.mConstituentField.addItem(newphrase);
            }
        }
        if (e.getSource() == this.mPhraseTextField) {
            if (newtext == null || newtext.toString().isEmpty()) {
                return;
            }
            if (this.mPhraseTextField.getSelectedIndex() < 0) {
                this.mPhraseTextField.addItem(newtext);
            }
        }
        if (e.getSource() == this.mFileButton) {
            this.selectFile();
        } else if (newphrase != null && !newphrase.toString().isEmpty() && newtext != null && !newtext.toString().isEmpty()) {
            this.doParsing();
        }
    }

    private void selectFile() {
        int returnVal = this.mFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.mFileChooser.getSelectedFile();
            this.mFileTextField.setText(file.getPath());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void doParsing() {
        block10: {
            this.mscrollPanel.removeAll();
            this.mMessageField.setMaximumSize(new Dimension(32767, 0));
            this.mMessageField.setPreferredSize(new Dimension(this.mMessageField.getWidth(), 0));
            try {
                parser = new ParseString(this.mFileTextField.getText());
                treeList = parser.parse(this.mPhraseTextField.getSelectedItem().toString(), this.mConstituentField.getSelectedItem().toString());
                if (treeList.isEmpty()) {
                    this.throwError("No valid tree found.", null);
                } else {
                    prefdim = new Dimension();
                    for (LayoutTree lt : treeList) {
                        pan = new TreeJPanel(lt);
                        prefdim.height += pan.getPreferredSize().height;
                        prefdim.width = Math.max(prefdim.width, pan.getPreferredSize().width);
                        this.mscrollPanel.add(pan);
                    }
                    warnings = parser.getWarnings();
                    if (!warnings.isEmpty()) {
                        this.mMessageField.setText(warnings);
                        this.mMessageField.setPreferredSize(new Dimension(this.mMessageField.getWidth(), this.mMessageField.getLineCount() * 18));
                        this.mMessageField.setMaximumSize(new Dimension(32767, this.mMessageField.getLineCount() * 18));
                    }
                    this.mscrollPanel.setPreferredSize(prefdim);
                    this.mscrollPanel.revalidate();
                    this.getContentPane().validate();
                }
                break block10;
            }
            catch (IOException exception) {
                this.throwError("Cannot open grammar file:\n", exception);
                break block10;
            }
            catch (GrammarFileException exception) {
                t /* !! */  = exception;
                ** while (t /* !! */ .getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                t /* !! */  = t /* !! */ .getCause();
                continue;
            }
lbl35:
            // 1 sources

            this.throwError("Error parsing grammar file:\n", t /* !! */ );
            break block10;
            catch (Exception exception) {
                t /* !! */  = exception;
                ** while (t /* !! */ .getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                t /* !! */  = t /* !! */ .getCause();
                continue;
            }
lbl42:
            // 1 sources

            this.throwError("Error parsing: ", t /* !! */ );
        }
    }

    private void throwError(String msg, Throwable t) {
        JLabel errmsg = new JLabel(String.valueOf(msg) + (t == null ? "" : t.getMessage()));
        errmsg.setAlignmentX(0.5f);
        errmsg.setAlignmentY(0.5f);
        this.mscrollPanel.add(Box.createRigidArea(new Dimension(1, 50)));
        this.mscrollPanel.add(errmsg);
        this.mscrollPanel.revalidate();
        this.mscrollPanel.setPreferredSize(this.mscrollPanel.getMinimumSize());
        this.mscrollPanel.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Gui();
            }
        });
    }
}

