/*
 * Decompiled with CFR 0.152.
 */
package speeth.output;

import java.util.Iterator;
import speeth.lang.Alphabet;
import speeth.lang.Constituent;
import speeth.lang.EncodingException;
import speeth.lang.Feature;
import speeth.lang.TLRAutomat;
import speeth.parser.TreeInfo;
import speeth.parser.TreeNode;
import speeth.transducer.Transducer;

public class SynTreeFormat {
    private TreeNode mTree;
    private Alphabet mPhon = Alphabet.getDefPhon();
    private Alphabet mGraph = Alphabet.getDefGraph();

    public SynTreeFormat(TreeNode t) {
        this.mTree = t;
    }

    public SynTreeFormat(TreeNode t, Alphabet graph, Alphabet phon) {
        this.mTree = t;
        this.mPhon = phon;
        this.mGraph = graph;
    }

    public String phonStringTLR(TLRAutomat tlr) throws EncodingException {
        Iterator<String> it;
        Transducer t = new Transducer(tlr);
        String ret = null;
        this.nodePhonStringTLR(t, this.mTree);
        if (t.getProcessedString().length() > 0) {
            t.feedEncode("#");
        }
        if (!(it = t.iterator()).hasNext()) {
            throw new EncodingException("No phonetic translation with TLR automaton.");
        }
        ret = this.mPhon.decode(it.next());
        if (it.hasNext()) {
            System.err.printf("Warning: More than one phonetic translation with TLR automaton.", new Object[0]);
        }
        return ret;
    }

    private void nodePhonStringTLR(Transducer t, TreeNode node) throws EncodingException {
        int num = node.getNumChildren();
        if (num == 0) {
            if (t.getProcessedString().length() > 0) {
                t.feedEncode(" ");
            }
            t.feed(node.getNodeInfo().getPhon());
        } else {
            int i = 0;
            while (i < num) {
                this.nodePhonStringTLR(t, node.getChild(i));
                ++i;
            }
        }
    }

    public String asciiTree() throws EncodingException {
        return this.nodeAsciiTree(this.mTree);
    }

    private String nodeAsciiTree(TreeNode node) throws EncodingException {
        int num = node.getNumChildren();
        TreeInfo inf = node.getNodeInfo();
        if (num == 0 && inf.isTree()) {
            return this.nodeAsciiTree(inf.getTree());
        }
        StringBuffer s = new StringBuffer("- ");
        this.consAsciiTreeString(s, node.getCons());
        if (num == 0) {
            s.append("   \"").append(this.mGraph.decode(inf.getGraph())).append("\"");
            String p = inf.getPhon();
            if (p != null) {
                s.append("  \"").append(this.mPhon.decode(p)).append("\"");
            }
            s.append("\n");
        } else {
            s.append("\n  |");
            int i = 0;
            while (i < num - 1) {
                s.append("\n  +").append(this.nodeAsciiTree(node.getChild(i)).replaceAll("\n", "\n  |")).append("\n  |");
                ++i;
            }
            s.append("\n  +").append(this.nodeAsciiTree(node.getChild(num - 1)).replaceAll("\n", "\n   "));
        }
        return s.toString();
    }

    private void consAsciiTreeString(StringBuffer s, Constituent cons) {
        s.append(cons.getName()).append(' ');
        Feature f = cons.getFeature();
        if (f != null) {
            this.featBraceString(s, f);
        }
    }

    public String braceString(TLRAutomat tlr, boolean syntreeonly) throws EncodingException {
        StringBuffer s = new StringBuffer();
        this.nodeBraceString(s, this.mTree, syntreeonly);
        if (tlr != null) {
            boolean doignore = true;
            Transducer t = new Transducer(tlr, true);
            while (s.length() > 0) {
                int idx = 0;
                if (doignore) {
                    idx = s.indexOf("[");
                    if (idx < 0) {
                        idx = s.length() - 1;
                    }
                    t.appendString(s.substring(0, idx + 1));
                    s.delete(0, idx + 1);
                    doignore = false;
                    continue;
                }
                idx = s.indexOf("]");
                assert (idx >= 0);
                if (idx > 0) {
                    t.reset();
                    t.feedEncode(s.substring(0, idx));
                    s.delete(0, idx);
                }
                doignore = true;
            }
            t.feedEncode("#");
            Iterator<String> it = t.iterator();
            if (it.hasNext()) {
                return it.next();
            }
            throw new EncodingException("No phonetic translation with TLR automaton.");
        }
        return s.toString();
    }

    private void nodeBraceString(StringBuffer s, TreeNode node, boolean syntreeonly) throws EncodingException {
        int num = node.getNumChildren();
        TreeInfo inf = node.getNodeInfo();
        if (!syntreeonly && num == 0 && inf.isTree()) {
            this.nodeBraceString(s, inf.getTree(), syntreeonly);
        } else {
            s.append("(");
            this.consBraceString(s, node.getCons());
            if (num == 0) {
                s.append('{').append(this.mGraph.decode(inf.getGraph())).append("}[");
                String p = inf.getPhon();
                if (p != null) {
                    s.append(this.mPhon.decode(p));
                }
                s.append(']');
            } else {
                int i = 0;
                while (i < num) {
                    this.nodeBraceString(s, node.getChild(i), syntreeonly);
                    ++i;
                }
            }
            s.append(")");
        }
    }

    private void consBraceString(StringBuffer s, Constituent cons) {
        s.append(cons.getName()).append(';');
        Feature f = cons.getFeature();
        if (f != null) {
            this.featBraceString(s, f);
        }
    }

    private void featBraceString(StringBuffer s, Feature f) {
        int n = f.getNumSubFeatures();
        if (n == 0) {
            s.append(f);
        } else {
            String delim = "";
            int i = 0;
            while (i < n) {
                s.append(delim).append('<');
                this.featBraceString(s, f.getSubFeature(i));
                s.append('>');
                delim = " ";
                ++i;
            }
        }
    }
}

