/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import speeth.lang.Alphabet;
import speeth.lang.Grammar;
import speeth.lang.GrammarFileException;
import speeth.lang.Lexicon;
import speeth.lang.SymbolPair;
import speeth.lang.TLRAutomat;
import speeth.parser.SentenceAnalyser;
import speeth.parser.WordAnalyser;

public class LangDB {
    Map<String, Lexicon> mLexica = new HashMap<String, Lexicon>();
    Map<String, Grammar> mGrammars = new HashMap<String, Grammar>();
    Map<String, TLRAutomat> mTLRs = new HashMap<String, TLRAutomat>();
    Map<String, Alphabet> mAlphabets = new HashMap<String, Alphabet>();
    SymbolPair mDontCareSymbols = null;

    public LangDB() {
        this.createDefaultEntries(true, true);
    }

    public LangDB(boolean createAlphabets, boolean createTLRs) {
        this.createDefaultEntries(createAlphabets, createTLRs);
    }

    public void createDefaultEntries(boolean alph, boolean tlr) {
        if (alph) {
            this.mAlphabets.put("phon", Alphabet.getDefPhon());
            this.mAlphabets.put("graph", Alphabet.getDefGraph());
        }
        if (tlr) {
            this.mTLRs.put("mograph", TLRAutomat.getDefGraphAutomat());
            this.mTLRs.put("mophon", TLRAutomat.getDefPhonAutomat());
        }
    }

    public void addLexicon(Lexicon lex) throws GrammarFileException {
        if (this.mLexica.put(lex.getName().toLowerCase(), lex) != null) {
            throw new GrammarFileException(0, "File contains two lexica named " + lex.getName());
        }
    }

    public void addGrammar(Grammar gram) throws GrammarFileException {
        if (this.mGrammars.put(gram.getName().toLowerCase(), gram) != null) {
            throw new GrammarFileException(0, "File contains two grammars named " + gram.getName());
        }
    }

    public void addTLR(TLRAutomat tlr) throws GrammarFileException {
        this.mTLRs.put(tlr.getName().toLowerCase(), tlr);
    }

    public void setAlphabet(String name, Alphabet abc) throws GrammarFileException {
        this.mAlphabets.put(name.toLowerCase(), abc);
    }

    public Grammar getGrammar(String name) {
        return this.mGrammars.get(name.toLowerCase());
    }

    public Lexicon getLexicon(String name) {
        return this.mLexica.get(name.toLowerCase());
    }

    public Alphabet getAlphabet(String name) {
        return this.mAlphabets.get(name.toLowerCase());
    }

    public TLRAutomat getTLR(String name) {
        return this.mTLRs.get(name.toLowerCase());
    }

    public Collection<String> getTLRs() {
        return this.mTLRs.keySet();
    }

    public void setDontCareSymbols(SymbolPair sym) {
        this.mDontCareSymbols = sym;
    }

    public SymbolPair getDontCareSymbols() {
        return this.mDontCareSymbols;
    }

    public WordAnalyser createWordAnalyser() throws GrammarFileException {
        Grammar wgram = this.mGrammars.get("wortgrammatik");
        Lexicon mlex = this.mLexica.get("morphemlexikon");
        Lexicon flex = this.mLexica.get("lexikon");
        if (flex == null) {
            flex = this.mLexica.get("vollformlexikon");
        } else if (this.mLexica.get("vollformlexikon") != null) {
            throw new GrammarFileException(-1, "File contains two full-form lexica: lexikon and vollformlexikon.");
        }
        if (flex == null && (mlex == null || wgram == null)) {
            throw new GrammarFileException(-1, "No lexicon found. You need to specify a full-form lexicon and/or a morphem lexicon with its grammar.");
        }
        return new WordAnalyser(wgram, flex, mlex, this.getTLR("mograph").getInverted());
    }

    public SentenceAnalyser createSentenceAnalyser() throws GrammarFileException {
        Grammar sgram = this.mGrammars.get("grammatik");
        if (sgram == null) {
            sgram = this.mGrammars.get("satzgrammatik");
        } else if (this.mGrammars.get("satzgrammatik") != null) {
            throw new GrammarFileException(-1, "File contains two grammars: grammatik and satzgrammatik.");
        }
        if (sgram == null) {
            StringBuffer s = new StringBuffer("No sentence grammar found. Available: " + this.mGrammars.keySet());
            throw new GrammarFileException(-1, s.toString());
        }
        return new SentenceAnalyser(sgram, this.createWordAnalyser());
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "============ Grammars ============";
        if (this.mGrammars.isEmpty()) {
            s = String.valueOf(s) + "\nnone";
        } else {
            for (Grammar g : this.mGrammars.values()) {
                s = String.valueOf(s) + "\n" + g.toString();
            }
        }
        s = String.valueOf(s) + "\n============ Lexica ==============";
        if (this.mLexica.isEmpty()) {
            s = String.valueOf(s) + "\nnone";
        } else {
            for (Lexicon l : this.mLexica.values()) {
                s = String.valueOf(s) + "\n" + l.toString();
            }
        }
        return s;
    }
}

