/*
 * Decompiled with CFR 0.152.
 */
package speeth.lang;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import speeth.lang.EncodingException;
import speeth.lang.SymbolPair;
import speeth.util.CharTree;
import speeth.util.CharTreeNavigator;
import speeth.util.Tuple;

public class Alphabet {
    CharTree<Character> mExtern = new CharTree();
    Map<Character, String> mIntern = new HashMap<Character, String>();
    private static Alphabet gDefGraph = null;
    private static Alphabet gDefPhon = null;
    private static String[] gGraphChars = new String[]{"+", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "\u00e4", "\u00eb", "\u00ef", "\u00f6", "\u00fc", "\u00e2", "\u00ea", "\u00ee", "\u00f4", "\u00fb", "\u00e1", "\u00e9", "\u00ed", "\u00f3", "\u00fa", "\u00e0", "\u00e8", "\u00ec", "\u00f2", "\u00f9", "\u00e3", "\u00f5", "\u00e5", "\u00e7", "\u00f1", "\u00e6", "\u00fd", "\u00fe", "\u00ff", "\u00df", "\u00a3", "%", "*", "\u00a9", "&", "@", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", " ", "?", ",", "\"", "-", "\\", ";", "(", ")", "[", "]", "{", "}", ".", "!", "\u00bf", ":", "'", "/", "\u00ab", "\u00bb", "\u00c2", "\u00ca", "\u00ce", "\u00d4", "\u00db", "\u00c3", "\u00d1", "\u00d5", "\u00c0", "\u00cc", "\u00c1", "\u00cd", "\u00c9", "\u00c7", "\u00c4", "\u00d6", "\u00dc", "\u00d8", "\u00d0", "#", "$"};
    private static String[] gPhonStrings = new String[]{"+", "-", "#", "|", "/", "(/)", "'", ",", " ", "$", ">t_S", ">t", ">p", ">k", ">g", ">d", ">b", "(U)", "(p)", "(t)", "(r)", "(k)", "(h)", "(@)", "^u_i:", "^u_O:", "^u_E:", "^u_a:", "^u_O", "^u_E", "^u_i", "^u_o", "^u_e", "^u_a", "^i_u:", "^i_O:", "^i_E:", "^i_a:", "^i_O", "^i_E", "^i_u", "^i_o", "^i_e", "^i_a", "@_U_@", "a_U_@", "O_I_@", "a_I_@", "?", "Z", "z", "H", "y_@", "^y", "Y", "y:", "y", "x", "w", "v_v", "v", "U_@", "^u", "U", "u:", "u", "t_S", "t_s", "t_h", "T", "t_t_s", "t_t_S", "t_t", "t", "s_s", "S_S", "s", "r_r", "R", "r", "p_h", "p_f", "p_p", "p", "~9", "~9:", "9:", "9", "2:", "2", "Q", "O_y", "O_I", "o_U", "~O", "~o", "~o:", "~O:", "^o", "O:", "O", "o:", "o", "N", "=n", "n_n", "n", "m_m", "=m", "m", "l_l", "L_L", "L", "=l", "l", "k_h", "k_k", "k", "J_J", "J", "j_j", "j", "I_@", "i_@", "^i", "I", "i:", "i", "h", "g_g", "G", "g", "F", "f_f", "f", "c", "@_U", "@", "e_@", "e_I", "~E:", "~E", "E:", "E", "e:", "e", "3:", "3", "D_+", "D", "d_z", "d_Z", "d_d_z", "d_d_Z", "d_d", "d", "C", "B", "b_b", "b", "a_U", "a_u", "a_I", "a_i", "^6", "6", "V", "~A", "~a", "~A:", "~a:", "A:", "A", "q", "a:", "a", "S", ">"};

    public boolean addPair(String extern, Character intern) {
        return this.mExtern.add(extern, intern) && this.mIntern.put(intern, extern) == null;
    }

    public Tuple<Character, Character> encodeCharTuple(SymbolPair t) throws EncodingException {
        return new Tuple<Character, Character>(Character.valueOf(this.encodeChar((String)t.getFirst())), Character.valueOf(this.encodeChar((String)t.getSecond())));
    }

    public char encodeChar(String str) throws EncodingException {
        if (str.length() == 0) {
            return '\u0000';
        }
        CharTreeNavigator<Character> nav = this.mExtern.navigate();
        int i = 0;
        while (i < str.length()) {
            if (!nav.forward(Character.valueOf(str.charAt(i)))) {
                throw new EncodingException("Illegal symbol <" + str + ">.");
            }
            ++i;
        }
        List<Character> l = nav.getContent();
        if (l == null) {
            throw new EncodingException("Illegal symbol <" + str + ">.");
        }
        return l.get(0).charValue();
    }

    public String decodeChar(char c) throws EncodingException {
        String s = this.mIntern.get(Character.valueOf(c));
        if (s == null) {
            throw new EncodingException("Unknown symbol '" + c + "' in string " + c);
        }
        return s;
    }

    public String encode(String str) throws EncodingException {
        if (str.length() == 0) {
            return "";
        }
        String out = "";
        char lastfound = '\u0000';
        int lastpos = -1;
        CharTreeNavigator<Character> nav = this.mExtern.navigate();
        int pos = 0;
        while (pos < str.length()) {
            if (nav.forward(Character.valueOf(str.charAt(pos)))) {
                List<Character> l = nav.getContent();
                if (l != null) {
                    lastfound = l.get(0).charValue();
                    lastpos = pos;
                }
                ++pos;
                continue;
            }
            if (lastpos == -1) {
                throw new EncodingException(pos == 0 ? "Illegal symbol at beginning of string." : "Illegal symbol in string after <" + str.substring(0, pos) + ">");
            }
            out = String.valueOf(out) + Character.toString(lastfound);
            pos = lastpos + 1;
            nav.reset();
            lastpos = -1;
        }
        if (lastpos != str.length() - 1) {
            throw new EncodingException("Cannot completely encode string <" + str + ">");
        }
        out = String.valueOf(out) + Character.toString(lastfound);
        return out;
    }

    public String decode(String str) throws EncodingException {
        StringBuffer ret = new StringBuffer("");
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String s = this.mIntern.get(Character.valueOf(c));
            if (s == null) {
                throw new EncodingException("Unknown symbol '" + c + "' in string " + str);
            }
            ret.append(s);
            ++n2;
        }
        return ret.toString();
    }

    public boolean containsIntern(Character c) {
        return this.mIntern.containsKey(c);
    }

    public static Alphabet getDefGraph() {
        if (gDefGraph == null) {
            gDefGraph = new Alphabet();
            String[] stringArray = gGraphChars;
            int n = gGraphChars.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!gDefGraph.addPair(s, Character.valueOf(s.charAt(0)))) {
                    throw new IllegalArgumentException("Graphemic symbol <" + s + "> declared twice.");
                }
                ++n2;
            }
        }
        return gDefGraph;
    }

    public static Alphabet getDefPhon() {
        if (gDefPhon == null) {
            gDefPhon = new Alphabet();
            char c = '\ue000';
            String[] stringArray = gPhonStrings;
            int n = gPhonStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                char c2 = c;
                c = (char)(c2 + 1);
                if (!gDefPhon.addPair(s, Character.valueOf(c2))) {
                    throw new IllegalArgumentException("Phonemic symbol <" + s + "> declared twice.");
                }
                ++n2;
            }
        }
        return gDefPhon;
    }
}

