%  Uebung 13  Aufgabe 1  
%
%  Generieren von Referenzmustern fuer die Worterkennung (pattern matching)  
%-------------------------------------------------------------------------

clear all

NumPatts = 10;      % Anzahl Referenzmuster:  1...NumPatts
Words = {'eins','zwei','drei','vier','fuenf','sechs','sieben', ...
         'acht','neun','null'};
    
Ncep = 12;        % Anzahl cepstrale Coeffizienten 
Nfilt = 24;       % Anzahl Filter in der Mel-Filterbank
WinSize = 240;    % Laenge des Analysefensters
WinShift = 80;    % Verschiebung des Analysefensters
win = hamming(WinSize);


dirnam = fullpath('ueb13_sigs');


%===== Schleife fuer das Generieren der Referenzmuster =====

totp = 0;
for pnum = 1:NumPatts,  
  disp(['Referenzmuster generieren fuer Wort "' Words{pnum} '"'])
  
                                 % Signale fuer Referenzmuster `pnum` suchen
  dlist = dir([dirnam '/sig' num2str(pnum) '.*.wav']);
  nfils = length(dlist);
  if nfils == 0
    disp(['  keine Signale gefunden'])
  else
    disp(['  aus ' num2str(nfils) ' Signalen'])
    
    dists = zeros(nfils,nfils);   % Distanzen zwischen allen Signale berechnen
    for reffn = 1:nfils 
      [refsig,fs] = audioread([dirnam '/' dlist(reffn).name]);
      [refcep,refrms] = extr_mfcc_and_rms(refsig,fs,Nfilt,win,WinShift,Ncep);

      for tstfn = 1:nfils 
        if tstfn ~= reffn
          [tstsig,fs] = audioread([dirnam '/' dlist(tstfn).name]);
          [tstcep,tstrms] = extr_mfcc_and_rms(tstsig,fs,Nfilt,win, ...
                              WinShift,Ncep);
          [dst,wcurve,dcurve] = dtw(refcep,tstcep,refrms,tstrms);
          dists(reffn,tstfn) = dst;
        end
      end
    end
                   % bestimmen, welches Signal als Zeitbasis zu verwenden ist 
    [x,idx] = min(sum(dists'));
    disp(['  Zeitbasis ist Signal  : ' dlist(idx).name])

                   % Referenzmuster mit Zeitbasis `dlist(idx).name` generieren
    [refsig,fs] = audioread([dirnam '/' dlist(idx).name]);
    [refcep,refrms] = extr_mfcc_and_rms(refsig,fs,Nfilt,win,WinShift,Ncep);
    refpatt_cep = refcep;
    refpatt_rms = refrms;
    for tstfn = 1:nfils 
      if tstfn ~= idx
        [tstsig,fs] = audioread([dirnam '/' dlist(tstfn).name]);
        [tstcep,tstrms] = extr_mfcc_and_rms(tstsig,fs,Nfilt,win,WinShift,Ncep);
        [dst,wcurve,dcurve] = dtw(refcep,tstcep,refrms,tstrms);
        refpatt_cep = refpatt_cep+tstcep(wcurve(:,2),:);       % aufsummieren
        refpatt_rms = refpatt_rms+tstrms(wcurve(:,2),:);
      end
    end
    refpatt_cep = refpatt_cep/nfils;                      % normieren
    refpatt_rms = refpatt_rms/nfils;
    save(['refpatt' num2str(pnum)],'refpatt_cep','refpatt_rms');  % speichern
    totp = totp+1;
  end  
end          
%==== Ende Schleife ... ====

disp(['Anzahl der generierten Referenzmuster:  ' num2str(totp)])
