%  Uebung 13  Aufgabe 3  
%
%  Aufnehmen von eigenen Sprachsignalen fuer die Referenzmuster
%-------------------------------------------------------------------------

clear all

nreps = 3;   % Zahl der Repetitionen jedes Wortes

dirnam = 'ueb13_sigs_own';  % Directory fuer die Signale

words = {'eins','zwei','drei','vier','fuenf','sechs','sieben', ...
         'acht','neun','null'};


%----- Sub-Directory fuer die Signale kreieren ----- 

if ~exist(dirnam,'dir')
  [ok,msg,msgid] = mkdir(dirnam);
  if ~ok
    disp(['*** ' msg])
    disp('Program abgebrochen')
    return
  end
end


%----- jedes Wort `nreps` Mal aufnehmen -----

for wnum = 1:length(words)
  word_done = 0;
  while ~word_done  
    for rnum = 1:nreps
      tstr = ['Aufnahme des Wortes:   "'   words{wnum} ...
              '"        (' num2str(rnum) ' von ' num2str(nreps) ')'];
      filnam = ['sig' num2str(wnum) '.' num2str(rnum) '.wav'];
      if ~exist([dirnam '/' filnam])
        status =  0;
        while ~status 
          status = record_word(filnam,dirnam,tstr); 
          if ~status
            disp('kein Wort gespeichert!');
            ch = ' ';
            while (ch ~= 'j') & (ch ~= 'n')
              ch = input(['Aufnahme abbrechen? (j|N) >> '],'s');
            end
            if lower(ch) == 'j'
              return
            end
          end
        end
      end
    end
                     % testen ob sich das laengste und das kuerzeste Wort 
                     % um mehr als einen Faktor 2 unterscheiden
    WinSize = 240;
    WinShift = 80;
    for rnum = 1:nreps
      filnam = [dirnam '/sig' num2str(wnum) '.' num2str(rnum) '.wav'];
      info = audioinfo(filnam);
      ssize = info.TotalSamples;
      len(rnum) = ssize;
    end  
    minfr = ceil((min(len)-WinSize+1)/WinShift);
    maxfr = ceil((max(len)-WinSize+1)/WinShift);
    if 2*minfr <= maxfr
      [x,idx] = max(len);
      filnam = ['sig' num2str(wnum) '.' num2str(idx) '.wav']; 
      disp(['Achtung:  Signal ' dirnam '/' filnam char(10) 'ist mehr als ' ... 
            'doppelt so lang wie das kuerzeste.' char(10) 'Diese Aufnahme ' ...
            'muss wiederholt werden!'])
      ch = ' ';
      while (ch ~= 'j') & (ch ~= 'n')
        ch = input(['Aufnahme jetzt wiederholen? (J|n) >> '],'s');
      end
      if lower(ch) == 'n'
        return
      end
      delete([dirnam '/' filnam])
    else
      word_done = 1;
    end
  end
end
disp('alle Woerter aufgenommen')


