%   Uebung 13  Aufgabe 2:  Worterkennung mit Mustervergleich  
%-------------------------------------------------------------------------
 
clear all;
 
NumPatts = 10;    % Anzahl Referenzmuster:  1...NumPatts
Words = {'eins','zwei','drei','vier','fuenf','sechs','sieben', ...
         'acht','neun','null'};
    
Ncep = 12;        % Anzahl cepstrale Coeffizienten 
Nfilt = 24;       % Anzahl Filter in der Mel-Filterbank
WinSize = 240;    % Laenge des Analysefensters
WinShift = 80;    % Verschiebung des Analysefensters
win = hamming(WinSize);

 
%---- Testsignal aufnehmen ----

tstfil = 'test.wav';
%>> ok = record_word(tstfil,[]);
if exist('ok','var')
  if ok == 0,  
    disp(['kein Sprachsignal aufgenommen'])
    return
  end 
else
  tstfil = 'u13_test.wav';   % Testsprachsignal mit dem Wort "sieben"
end


%---- Testsignal laden, Cepstrum berechnen und Endpunkte detektieren ----

[tstsig,fs] = audioread(tstfil);
[tstcep,tstrms] = extr_mfcc_and_rms(tstsig,fs,Nfilt,win,WinShift,Ncep);
display_sig(tstsig,tstrms,WinSize,WinShift,fs,1,'zu erkennendes Wort');

dists = zeros(NumPatts,1);


%==== Schleife fuer den Vergleich mit den Referenzmustern ====

if isempty(dir('refpatt*.mat')) 
  disp('Keine Referenzmuster vorhanden!')
  disp('(Programm abgebrochen)')
  return
end
       
for pnum = 1:NumPatts, 	
  if exist(['refpatt' num2str(pnum) '.mat'],'file') == 0
    dst = 999;
    wcurve = [];
  else
    load(['refpatt' num2str(pnum)]);     % Referenzmuster laden
                        % Zeitnormalisation / Berechnung minimale Distanz 
    [dst,wcurve,dcurve] = dtw(refpatt_cep,tstcep,refpatt_rms,tstrms);
  end
  dists(pnum) = dst;
  disp(['Distanz zu Referenzmuster ' num2str(pnum) ':  ' num2str(dst)]);

  if ~isempty(wcurve)                      % Darstellen der Warping-Kurve 
    plot_warp_curve(wcurve,dcurve,refpatt_rms,tstrms,dst,2,pnum);
  end
  drawnow
  pause(0);
end 
           
%==== Ende Schleife ... ====


%---- Auswertunng der Distanzen ----

[dsts,ind] = sort(dists);
if dsts(1) >= 999
  str = ['    ----->>  eingegebendes Wort ist ungueltig!'];
else    
  str = ['    ----->>  erkanntes Wort:  "' Words{ind(1)} '"'];
end
disp(str);


%---- Berechnen und anzeigen der Warpingkurve des Resultatwortes ----

if dsts(1) < 999
  pnum = ind(1);
  load(['refpatt' num2str(pnum)]);        % Referenzmuster laden
  [dst,wcurve,dcurve] = dtw(refpatt_cep,tstcep,refpatt_rms,tstrms);
  dists(pnum) = dst;
  disp(['Distanz zu Muster ' num2str(pnum) ':  ' num2str(dst)]);

  if ~isempty(wcurve)
    plot_warp_curve(wcurve,dcurve,refpatt_rms,tstrms,dst,2,pnum);
  end
end
