function plot_warp_curve(wcurve,dcurve,ref,tst,mean_dst,fig,num)
%
%  function:  plot_warp_curve(wcurve,dcurve,ref,tst,mean_dst,fig,num)
%
%  The warp curve, the distance contour (local distances along the 
%  warp curve), the reference and test RMS contours are plotted 
%  in MATLAB figure number 'fig'. 
%
%  Inputs:   wcurve   warp curve (matrix with indices of the feature 
%                     vectors of the reference contour (1st column) and 
%                     of the test contour (2nd column))
%            dcurve   local distances along the warp curve
%            refrms   reference RMS contour 
%            tstrms   test RMS contour 
%            dst      distance (output from DTW algorithm)
%            fig      Matlab figure number 
%            num      number of the reference pattern


if (length(ref) ~= size(wcurve,1)) | (length(ref) ~= length(dcurve))
  disp(['size of warp curve:       ',num2str(size(wcurve,1))]);
  disp(['size of distance curve:   ',num2str(length(dcurve))]);
  disp(['size of ref gain contour: ',num2str(length(ref))]);
  error(['sizes of warp curve, distance curve, and reference pattern ' ...
         'are different'])
end
  
h = figure(fig);
set(h,'pointer','crosshair');
set(gcf,'menubar','none')
clf;

%---- draw the warp curve ----
%
axes('position',[0.18 0.40 0.55 0.55])
plot(wcurve(:,1),wcurve(:,2));
set(gca,'xlim',[0 size(wcurve,1)+1])
set(gca,'xticklabel',[''])
set(gca,'ylim',[0 length(tst)+1])
set(gca,'yticklabel',[''])
set(gca,'xgrid','on')
set(gca,'ygrid','on')

%---- write curve number and distance ... ----
%
h = text(length(ref)*.15,length(tst)*0.79,'warp curve');
set(h,'fontsize',16)
text(length(ref)*0.15,length(tst)*0.69,['for reference pattern ' num2str(num)])
text(length(ref)*1.07,length(tst)*0.55,'mean distance');
text(length(ref)*1.07,length(tst)*0.48,'along warp curve:');
text(length(ref)*1.07,length(tst)*0.40,[' -->  ' num2str(mean_dst)]);
text(length(ref)*1.07,-length(tst)*0.15,'reference RMS contour');
text(length(ref)*1.07,-length(tst)*0.41,'local distances');
text(length(ref)*1.07,-length(tst)*0.48,'along warp curve');

%---- draw the reference gain curve ----
%
axes('position',[0.18 0.235 0.55 0.15])
plot((1:length(ref)),ref/max(ref)*0.95);
set(gca,'xlim',[0 length(ref)+1])
set(gca,'xticklabel',[''])
set(gca,'ytick',[0 0.5])

%---- draw the distances ----
%
axes('position',[0.18 0.07 0.55 0.15])
plot((1:length(dcurve)),dcurve,'+','markersize',4);
set(gca,'xlim',[0 length(dcurve)+1])
set(gca,'ylim',[0 max(dcurve)*1.05])
set(gca,'ygrid','on')

%---- draw the test gain curve ----
%
axes('position',[0.05 0.40 0.12 0.55])
plot(tst/max(tst)*0.95,(1:length(tst)));
set(gca,'xdir','reverse')
set(gca,'xtick',[0.5 1])
set(gca,'ylim',[0 length(tst)+1])

drawnow;

