function display_sig(sig,rms,winsize,winshift,fs,fig,titstr)
%
%  function:  display_sig(sig,rms,winsize,winshift,fs,fig,titstr)
%
%  Display the signal `sig` and the intensity contour `rms` as Matlab 
%  figure `fig`.

figure(fig);
clf
set(gcf,'menubar','none');
pos = get(gcf,'position');
if pos(4) == 420
  z = pos(1)+pos(3)/2;
  pos(1) = floor(0.1*pos(1));
  pos(3) = 2*(z-pos(1));
  pos(4) = floor(0.38*pos(2));
  pos(2) = floor(0.5*pos(2));
  set(gcf,'position',pos);
end
axes('position',[0.05 0.09 0.93 0.75]);
slen = length(sig);
plot((0:slen-1)/fs,sig);
set(gca,'xlim',[0 (slen-1)/fs]);
set(gca,'ylim',[min(sig) max(sig)]*1.03);
title(titstr,'fontsize',14)

hold on
stem((winsize/2+(0:(length(rms)-1))*winshift)/fs,rms,'r');
hold off

pause(0.2);

