%  Uebung 12: Aufgaben 1 und 2
%--------------------------------------

clear all;

xfil = 'u12_sig_x.wav';
yfil = 'u12_sig_y_a.wav';

ns = [];   % Anzahl der Abtastwerte, die von den Signal-Dateien
           % gelesen werden sollen ([] = alle)
           % zum Testen z.B. auf 700 setzen

%---- Pfaderweiterungen und Pfadgewichte setzen ----

aufg = 1;

if aufg == 1 
  pe{1} = [-2 -1];     % Pfaderweiterungen Aufgabe 1  
  pe{2} = [-1 -1];
  pe{3} = [-1 -2];
  pg{1} = 3;           % Pfadgewichte Aufgabe 1
  pg{2} = 2;
  pg{3} = 3;
else
  pe{1} = [-1  0];     % Pfaderweiterungen Aufgabe 2    
  pe{2} = [-1 -1];
  pe{3} = [ 0 -1];
  pg{1} = 1;           % Pfadgewichte Aufgabe 2
  pg{2} = 2;
  pg{3} = 1;
end


%---- Figur vorbereiten ----

figure(aufg)                   % Figuren-Window oeffnen 
clf;
pos = get(gcf,'position');     % ... und vergroessern
if pos(3) == 560
  set(gcf,'position',[300 250 800 700])
end
h1 = axes('position',[0.06 0.79 0.35 0.17]);   % Teilfigur c(0) der Signale
h2 = axes('position',[0.06 0.33 0.35 0.35]);   % Teilfigur Warping-Kurve
h3 = axes('position',[0.06 0.05 0.35 0.17]);   % Teilfigur zeitnorm. Muster
h4 = axes('position',[0.48 0.55 0.50 0.40]);   % Teilfigur lokale Dist.
h5 = axes('position',[0.48 0.05 0.50 0.40]);   % Teilfigur akkumul. Dist.


%---- Signale laden, Mel-Cepstren berechnen und c(0) darstellen ----

disp('Signale laden und Cepstren berechnen ...')

if isempty(ns)                     % alle Abtastwerte der Signale laden
  [sx,fs] = audioread(xfil);
  [sy,fs] = audioread(yfil);
else                               % nur `ns` Abtastwerte der Signale laden
  [sx,fs] = audioread(xfil,ns);
  [sy,fs] = audioread(yfil,ns);
end

nceps = 13;                % Zahl der cestralen Koeffizienten (inkl. nullter) 
X = extr_mel_ceps(sx,fs,hamming(200),80,24,nceps);  % Mel-Cepstren berechnen
Y = extr_mel_ceps(sy,fs,hamming(200),80,24,nceps);

Lx = size(X,1);
Ly = size(Y,1);

cnum = 1;        % Wahl des cepstralen Koeffizienten, dessen Verlauf in den 
                 % Teilfiguren links oben und link unten gezeichnet wird
set(gcf,'CurrentAxes',h1)
plot(X(:,cnum),'-r');
hold on;
plot(Y(:,cnum),'-b');
plot(X(:,cnum),'or','MarkerSize',4);
plot(Y(:,cnum),'ob','MarkerSize',4);
hold off;
set(gca,'xlim',[1 max(Lx,Ly)])
title(['c(' num2str(cnum-1) ') der beiden Signalmuster']);
xlabel('Index des Analyseabschnittes')
ylabel(['c(' num2str(cnum-1) ')'])
legend('X','Y');


%---- Berechnung der Distanzmatrix ----

disp('Berechnen der lokalen Distanzen ...')
% (der nullte cepstrale Koeffizient wird nicht beruecksichtigt)
for i = 1:Lx
  for j = 1:Ly
    d(i,j) = sqrt(sum((X(i,2:nceps)-Y(j,2:nceps)).^2));
  end     
end

set(gcf,'CurrentAxes',h4)
surf(d');
v = [1 Lx 1 Ly 0 max(max(d))];
axis(v);
set(gca,'view',[-30 75])
title('Lokale Distanzen');
drawnow


%---- Berechnung der Warping-Kurve ----

disp('Berechnen der Warping-Kurve ...')
Da = zeros(Lx,Ly)+inf;  % Matrix der akkumulierten Distanzen initialisieren
Da(1,1) = d(1,1);       % Da(1,1) entspricht gerade der lokalen Distanz
                        % in diesem Punkt 

np = length(pe);
for x = 1:Lx          %  DTW-Rekursion:  ueber Muster X 
  for y = 1:Ly        %                  ueber Muster Y
    for i = 1:np      %                  ueber Pfaderweiterungen 
      if x+pe{i}(1) < 1 | y+pe{i}(2) < 1    % falls Pfaderweiterung nicht
        Dx(i) = inf;                        % innerhalb der Distanzmatix
      else
        Dx(i) = Da(x+pe{i}(1),y+pe{i}(2)) + d(x,y)*pg{i};
      end
    end
    if min(Dx) < inf
      [Da(x,y) idx] = min(Dx);  % Index der optimalen Pfaderweiterung aus
      psi(x,y) = idx;           % Punkt (x,y) bestimmen und in psi speichern
    else
      psi(x,y) = 0;
    end
  end;
end;


%---- akkumulierte Distanzen darstellen ----

set(gcf,'CurrentAxes',h5)
surf(Da');     % Darstellung der akkumulierten Distanzen
v = [1 Lx 1 Ly 0 max(max(Da))];
axis(v);
set(gca,'view',[-30 60])
title('Akkumulierte Distanzen');


%---- optimalen Pfad bestimmen (zurueck verfolgen) ----

disp('Ermitteln des optimalen Pfades ...')
if psi(Lx,Ly) == 0
  disp('*** Keine Warping-Kurve gefunden!')
  return
end
    
Pr(1,:) = [Lx Ly];  % Anfang des Rueckwaertspfades = Ende des optimalen Pfades
Ga = 0;             % akkumulierte Gewichtungen entlang des optimalen Pfades
k = 1;
while Pr(k,1) > 1 | Pr(k,2) > 1,
  psik = psi(Pr(k,1),Pr(k,2));
  Pr(k+1,:) = Pr(k,:)+pe{psik};
  Ga = Ga+pg{psik};
  k = k+1;
end;
Ga = Ga+1;            % Gewicht des Endpunktes des Rueckwaertspfades addieren
Lp = k;               % Laenge des optimalen Pfades
P = Pr(k:-1:1,:);     % optimaler Vorwaertspfad

dtwdist = Da(Lx,Ly)/Ga;
disp(['Normierte Distanz:  ' num2str(dtwdist)])


%---- optimalen Pfad (Warping-Kurve) darstellen ----

set(gcf,'CurrentAxes',h2)
plot(P(:,1),P(:,2),'+r','MarkerSize',4);  
set(gca,'xlim',[1 Lx])
set(gca,'ylim',[1 Ly])
xlabel('Index des Musters X')
ylabel('Index des Musters Y')
title('Warping-Kurve');
text(1+0.05*(Lx-1),1+0.85*(Ly-1),['Normierte Distanz:  ' num2str(dtwdist)])


%---- Distanzen entlang des optimalen Pfades darstellen ----

for k = 1:Lp                       
  D_opt(k) = d(P(k,1),P(k,2));     % lokale Distanz
  Da_opt(k) = Da(P(k,1),P(k,2));   % akkumulierte Distanz 
end
set(gcf,'CurrentAxes',h4)          % lokale Distanzen zeichnen
hold on
plot3(P(:,1),P(:,2),D_opt,'-r','linewidth',2)
set(gcf,'CurrentAxes',h5)          % lokale Distanzen zeichnen
hold on
plot3(P(:,1),P(:,2),Da_opt,'-r','linewidth',2)


%---- zeitnormalisierte Muster darstellen ----

set(gcf,'CurrentAxes',h3)
plot((1:Lp),X(P(:,1),cnum),'-r') 
hold on;
plot((1:Lp),Y(P(:,2),cnum),'-b') 
plot((1:Lp),X(P(:,1),cnum),'or','MarkerSize',4) 
plot((1:Lp),Y(P(:,2),cnum),'ob','MarkerSize',4) 
hold off;
set(gca,'xlim',[1 Lp])
title(['c(' num2str(cnum-1) ') der zeitnormalisierten Muster']);
xlabel('Index der Warping-Kurve');
ylabel(['c(' num2str(cnum-1) ')'])
legend('X','Y');

