%  Uebung 11  Aufgabe 1
%--------------------------------------------------------------------------
%
%  Vergleich des Fourier-Spektrums mit dem LPC-Spektrum und mit dem
%  cepstral geglaetteten Fourier-Spektrum

clear all

signum = 1;   % 1:  Laut [i], Maennerstimme
              % 2:  Laut [i], Frauenstimme


%  Programm-Parameter
%--------------------------------------------------------------------------

winlen = 240;     % Laenge Analysefenster [Abtastwerte]
nfft = 512;       % FFT-Aufloesung  (nfft > winlen --> zero padding)
cepwinlen = 20;   % Laenge des cepstralen Fensters
order = 16;       % Ordnung des Praediktors


%  Lautsegment laden und mit Hamming-Fenster multiplizieren
%--------------------------------------------------------------------------

if signum == 1
  filnam = 'seg_phone_i_A1.wav';
else
  filnam = 'seg_phone_i_B1.wav';
end
[s,fs] = audioread([fullpath('ueb11_sigs/') filnam]); 

win = 1.588*hamming(winlen);      % leistungskompensiertes Hamming-Fenster
sw = (s(1:winlen).*win)';


%  Fourierspektrum und cepstrale Glaettung davon berechnen
%--------------------------------------------------------------------------

lc = cepwinlen;                   % cepstrales Fenster
cepwin = [ones(1,lc+1) zeros(1,nfft-2*lc-1) ones(1,lc)];

                                  % Leistungsdichtespektrum in dB
power_spec = 10*log10(abs(fft(sw,nfft)).^2/length(s));
cep = real(ifft(power_spec));     % Realteil des reellen Cepstrums
smspec = real(fft(cep.*cepwin));  % Realteil des geglaetteten Spektrums
                                  % (falls Funktion rceps gebraucht wird
                                  %  um das Cepstrum zu berechnen, dann
                                  %  ist das Resultat zu skalieren!)


%  LPC-Spektrum berechnen
%--------------------------------------------------------------------------

[A,E] = lpc(sw,order);                % LPC-Praediktor berechnen

B = sqrt(E);                          % LPC-Spektrum (ganzer Frequenzbereich)
[HH,F] = freqz(B,A,nfft,'whole',fs);
HH = 20*log10(abs(HH));               % Betrag des LPC-Spektrums in dB 


%  Spektren zeichnen 
%--------------------------------------------------------------------------

figure(signum)
clf

legendstr = {};
plot((0:nfft/2-1)/nfft*fs,power_spec(1:nfft/2));   % Leistungsdichtespektrum
legendstr{end+1} = 'Fourierspektrum';
hold on;

plot((0:nfft/2-1)/nfft*fs,smspec(1:nfft/2),'-r');  % geglaettetes Spektrum
legendstr{end+1} = 'gegl. Fourierspektrum';

plot(F(1:nfft/2),HH(1:nfft/2),'-k');               % LPC-Spektrum
legendstr{end+1} = ['LPC' num2str(order) '-Spektrum'];
hold off;

set(gca,'box','on');
set(gca,'ylim',[-70 0]);
ylabel('Betrag in dB');
legend(legendstr);
if signum == 1
  str = '  (Maennerstimme)';
else
  str = '  (Frauenstimme)';
end
title(['Spektren des Lautes [i]' str]);

echo on

% Die beiden geglaetteten Spektren zeigen zur Hauptsache:
% 
%  - Beim LPC-Spektrum (schwarz) sind die Gipfel ausgepraegter als die 
%    Taeler, insbesondere bei der Frauenstimme. 
%    (H(z) ist ein Allpolfilter!)
%
%  - Beim cepstral geglaetteten Fourierspektrum (rot) sind Gipfel und 
%    Taeler gleich ausgepraegt.
%
%  - Das cepstral geglaettete Spektrum und das LPC-Spektrum liegen bei 
%    Maennerstimme naeher beieinander als bei der Frauenstimme. Da in  
%    beiden Faellen dasselbe Analysefenster verwendet worden ist (gleicher
%    Schmiereffekt), sind die Zwischenraeume zwischen den Harmonischen 
%    bei der Frauenstimme viel groesser, wodurch die geglaettete Kurve 
%    weiter unten zu liegen kommt.
%
%  - Mit zunehmender Praediktorordnung wird das Sprachsignal und damit auch 
%    dessen Spektrum immer genauer approximiert. Wenn die Ordnung genuegend
%    hoch ist erscheint insbesondere auch die Welligkeit im LPC-Spektrum.
%    Das Fourier- und das LPC-Spektrum werden aber nie identisch und damit
%    auch die geglaetteten Spektren nicht, weil der Praediktionsfehler eines
%    zeitlich begrenzten Signalabschnittes nicht null werden kann.
echo off
