%  Uebung 11  Aufgabe 3   (Programmrahmen)
%--------------------------------------------------------------------------
%
%  Mel-cepstrale Distanzen zwischen den Lautsegmenten in den 
%  Files  ueb11_sigs/seg_phone_X_SY.wav  berechnen und anzeigen,
%  wobei X den Laut bezeichnet, S den Sprecher und Y die Files 
%  mit gleichem Laut und Sprecher nummeriert.


clear all

featype = [];
while isempty(featype)
  featype = input(['Bitte eines der folgenden Sprachmerkmale auswaehlen:' ...
                 '\n  0: Zufallswerte' ...
                 '\n  1: Mel-Cepstrum (MFCC)' ...
                 '\n  2: Mel-Spektrum' ...
                 '\n  3: DFT-Cepstrum' ...
                 '\n  4: LPC-Koeffizienten' ...
                 '\n  5: Autokorrelation   >>   ']);
end

%  Programm-Parameter
%--------------------------------------------------------------------------

lenvc = 13;       % Laenge Merkmalsvektors
nfilt = 24;       % Anzahl Filter in der Mel-Filter-Bank


%  Signale laden und Mel-Cepstren berechnen 
%--------------------------------------------------------------------------

fp_ueb11_sigs = fullpath('ueb11_sigs/');
fils = dir([fp_ueb11_sigs 'seg_phone_*.wav']);   % alle Filenamen lesen

phone_names = [];               % Lautnamen aus Filenamen zusammenstellen
for fn = 1:length(fils)
  fname = fils(fn).name;
  if isempty(findstr(fname(11),phone_names))
    phone_names = [phone_names fname(11)];
  end
end
lphn = length(phone_names);


disp(['Merkmale extrahieren ...']);         % Merkmale extrahieren
for fnum = 1:length(fils)
  fname = fils(fnum).name;
  [x,fs] = audioread([fp_ueb11_sigs fname]);
  xw = x.*hamming(length(x));
  switch featype  
    case 0  % Merkmalsvektor mit Zufallswerten
      feaname = 'Merkmalsvektor mit Zufallswerten';
      fea = rand(1,lenvc);
    case 1  % Mel-Cepstrum
      feaname = 'Mel-Cepstrum';
      fea = mfcc(xw,fs,nfilt,lenvc);
%>>    case 2  % Mel-Spektrum

%>>    case 3  % DFT-Cepstrum

%>>    case 4  % LPC-Koeffizienten

%>>    case 5  % Autokorrelation

    otherwise
      error('*** kein gueltiges Merkmal gewaehlt')
    end
  cc(1:lenvc,fnum) = fea(1:lenvc);    % Merkmalsvektoren in Matrix speichern
end


%  Distanzen berechnen
%--------------------------------------------------------------------------
%  zwischen gleichen Lauten    -->  Eigendistanz  (self distance)
%  zwischen verschied. Lauten  -->  Kreuzdistanz  (cross distance)

disp(['Distanzen berechnen ...']);          % Distanzen berechnen
dists = zeros(lphn,lphn,lphn.^2);           % Distanzmatrix initialisieren
poi_d = zeros(lphn,lphn);                   % Zeiger in Distanzmatrix 
d_self = [];                                % Eigendistanz-Vektor initialis.
d_cross = [];                               % Kreuzdistanz-Vektor initialis.
for fnum1 = 1:length(fils)
  for fnum2 = fnum1+1:length(fils)
    d = sqrt(sum((cc(:,fnum1)-cc(:,fnum2)).^2));
    idx1 = findstr(phone_names,fils(fnum1).name(11));
    idx2 = findstr(phone_names,fils(fnum2).name(11));
    poi_d(idx1,idx2) = poi_d(idx1,idx2)+1;  % Dist in Distanzmatrix 
    dists(idx1,idx2,poi_d(idx1,idx2)) = d;
    if idx1 == idx2 
      d_self(end+1) = d;                    % Dist in Eigendistanz-Vektor
    else
      d_cross(end+1) = d;                   % Dist in Kreuzdistanz-Vektor
    end
  end
end


%  Histogramme der Eigen- und Kreuzdistanzen
%--------------------------------------------------------------------------

figure(1+(featype>1))
clf
[n,x] = hist([d_cross d_self],20);    % bestimmen der Bin-Mitten --> x 
subplot(2,1,1)
hist(d_self,x)
title(['Histogramm der Eigendistanzen fuer ' feaname])
subplot(2,1,2)
hist(d_cross,x)
title(['Histogramm der Kreuzdistanzen fuer ' feaname])


%  Mittelwerte der Eigen- und Kreuzdistanzen pro Laut(paar) 
%--------------------------------------------------------------------------

for ii = 1:lphn
  for jj = 1:lphn
    if poi_d(ii,jj) > 0
      dd = [];
      dd(1:poi_d(ii,jj)) = dists(ii,jj,1:poi_d(ii,jj));
      means(ii,jj) = mean(dd);
    else
      means(ii,jj) = 0;
    end
  end
end

disp(' ')
disp('Mittelwerte der Eigen- und Kreuzdistanzen pro Laut(paar):')
fprintf(2,'---------------------------------------------------------------')
fprintf(2,'------------\n   ')
for jj = 1:lphn
  fprintf(2,'    %s  ',phone_names(jj))
end
fprintf(2,'\n')
for ii = 1:lphn
  fprintf(2,'\n  %s ',phone_names(ii))
  for jj = 1:lphn
    if poi_d(ii,jj) > 0
      fprintf(2,' %5.2f ',means(ii,jj))
    else
      fprintf(2,'  ---- ') 
    end
  end
%  fprintf(2,'\n')
end
fprintf(2,'\n-------------------------------------------------------------')
fprintf(2,'--------------\n')


%  Guetekriterium (Fisher-Distanz)
%--------------------------------------------------------------------------
%  Die Guete der Sprachmerkmale wird daran gemesssen, wie gut sich damit
%  Laute unterscheiden lassen. Die Unterscheidbarkeit ist im Mittel umso 
%  besser, je staerker sich die Eigendistanzen (Distanz zwischen zwei
%  gleichen Lauten) von den Kreuzdistanzen (Distanz zwischen 
%  verschiedenen Lauten) unterscheiden. 
%  Die Fisher-Distanz quantifiziert dies wie folgt: Differenz der 
%  Distanzmittelwerte im Quadrat durch Summe der Varianzen der Distanzen. 

fdist = (mean(d_cross)-mean(d_self)).^2 / (var(d_cross)+var(d_self));
disp(['Guetemass (Fisher-Distanz) fuer ' feaname ':  ' num2str(fdist)])


