function  ueb11_2(filnam,dispfb)
%
%  function  ueb11_2(filnam,dispfb)
%
%  Diese Matlab-Funktion wird fuer die Aufgabe 2 der Uebung 11 gebraucht.
%  Die Eingabeargumente sind:
%
%    filnam    Name der zu verwendenden Datei mit einem Signalsegment;
%              Der Dateiname hat die Form  seg_phone_L_SN.wav,
%              wobei L, S und N die folgende Bedeutung haben: 
%              Laute:     a, e, i, o, u, l, m, n, f, s 
%              Sprecher:  A (Maennerstimme), B (Frauenstimme)
%              Nummern:   1, 2, ... 9
%              (ohne Eingabe wird  'seg_phone_e_A1.wav'  gewaehlt)                
%
%    dispfb    optinales Argument zur darstellung der Mel-Filterbank 
%              1:  Mel-Filterbank wird als Figur 3 angezeigt  
%              0:  keine Anzeige


if (nargin < 2) | (dispfb ~= 1)
  dispfb = 0;
end
if (nargin < 1) | isempty(filnam)
  filnam = 'seg_phone_e_A1.wav';
end


%  Parameter
%--------------------------------------------------------------------------

winlen = 240;     % Laenge Analysefenster [Abtastwerte]
nfft = 512;       % FFT-Aufloesung  
cepwinlen = 13;   % Laenge des cepstralen Fensters
nfilt = 24;       % Anzahl Filter in der Mel-Filterbank



%  Lautsegment laden und graphisch darstellen
%--------------------------------------------------------------------------

fp_ueb11_sigs = fullpath('ueb11_sigs/');      % voller Pfad zu Subdirectory
[s,fs] = audioread([fp_ueb11_sigs filnam]);

figure(1)
clf
subplot(2,1,1)
t = (0:length(s)-1)/fs;
plot(t,s)
title(['Sprachsignal des Lautes [' filnam(11) ']    (File: ' filnam ')'], ...
       'interpreter','none')



%  Fourierspektrum und cepstrale Glaettung davon 
%--------------------------------------------------------------------------

                                    % Signal mit Hamming-Fenster multipliz.
sw = (s(1:winlen).*hamming(winlen))';

SdB = 20*log10(abs(fft(sw,nfft)));  % Betragsspektrum in dB

ftcep = real(ifft(SdB));            % Realteil des reellen Cepstrums
                                    % (Imaginaerteil ist nur fast null)

lc = cepwinlen;                     % cepstrales Fenster
cepwin = [ones(1,lc+1) zeros(1,nfft-2*lc-1) ones(1,lc)];
SdBsm = real(fft(ftcep.*cepwin));   % Betrag des geglaetteten Spektrums
                                    % (falls Funktion rceps gebraucht wird
                                    %  um das Cepstrum zu berechnen, dann
                                    %  ist das Resultat zu skalieren!)
figure(2) 
clf
legendstr = {};

f = (0:nfft/2-1)/nfft*fs;
plot(f,SdB(1:nfft/2));              % Fourierspektrum zeichnen
legendstr{end+1} = 'Fourierspektrum';
hold on;

plot(f,SdBsm(1:nfft/2),'-r');       % geglaett. Fourierspektrum zeichnen
legendstr{end+1} = 'gegl. Fourierspektrum';


%  Mel-Spektrum und cepstrale Glaettung davon berechnen
%--------------------------------------------------------------------------

[melspec,fmel] = mel_spectrum(sw,fs,nfft,nfilt,1,(dispfb>0)*3);
logmelspec = log(melspec);                 % log Mel-Spektrum
melcep = dct(logmelspec);                  % Mel-Cepstrum
                                           % geglaett. log Mel-Spektrum
logmelspecsm = idct([melcep(1:cepwinlen)' zeros(1,nfilt-cepwinlen)]); 

figure(2)
plot(fmel,20/log(10)*logmelspec,'-k');     % Mel-Spektrum (in dB)
legendstr{end+1} = 'Mel-Spektrum';

plot(fmel,20/log(10)*logmelspecsm,'-g');   % geglaett. Mel-Spektrum (in dB)
legendstr{end+1} = 'gegl. Mel-Spektrum';
legend(legendstr);

plot(fmel,20/log(10)*logmelspec,'ok','markersize',4);
plot(fmel,20/log(10)*logmelspec,'ok','markersize',3);
plot(fmel,20/log(10)*logmelspecsm,'og','markersize',4);      
plot(fmel,20/log(10)*logmelspecsm,'og','markersize',3);      
hold off;

set(gca,'ylim',[-40 20])
xlabel('Frequenz in Hz');
ylabel('Betrag in dB');
title([' Cepstral geglaettetes Mel-Spektrum des Lautes [' filnam(11) ...
       ']    (cepwinlen = ' num2str(cepwinlen) ')']);

