%  Uebung 11  Aufgabe 1   (Programmrahmen)
%--------------------------------------------------------------------------
%
%  Vergleich des Fourier-Spektrums mit dem LPC-Spektrum und mit dem
%  cepstral geglaetteten Fourier-Spektrum

clear all

signum = 1;   % 1:  Laut [i], Maennerstimme
              % 2:  Laut [i], Frauenstimme


%  Programm-Parameter
%--------------------------------------------------------------------------

winlen = 240;     % Laenge Analysefenster [Abtastwerte]
nfft = 512;       % FFT-Aufloesung  (nfft > winlen --> zero padding)
cepwinlen = 20;   % Laenge des cepstralen Fensters
order = 16;       % Ordnung des Praediktors


%  Lautsegment laden und mit Hamming-Fenster multiplizieren
%--------------------------------------------------------------------------

if signum == 1
  filnam = 'seg_phone_i_A1.wav';
else
  filnam = 'seg_phone_i_B1.wav';
end
[s,fs] = audioread([fullpath('ueb11_sigs/') filnam]); 

win = 1.588*hamming(winlen);      % leistungskompensiertes Hamming-Fenster
sw = (s(1:winlen).*win)';


%  Fourierspektrum und cepstrale Glaettung davon berechnen
%--------------------------------------------------------------------------

lc = cepwinlen;                   % cepstrales Fenster
%>> cepwin = ...

%>> power_spec = ...              % Leistungsdichtespektrum in dB
%>> cep = ...                     % Realteil des reellen Cepstrums
%>> smspec = ...                  % Realteil des geglaetteten Spektrums
                                  % (falls Funktion rceps gebraucht wird
                                  %  um das Cepstrum zu berechnen, dann
                                  %  ist das Resultat zu skalieren!)


%  LPC-Spektrum berechnen
%--------------------------------------------------------------------------

[A,E] = lpc(sw,order);                % LPC-Praediktor berechnen

B = sqrt(E);                          % LPC-Spektrum (ganzer Frequenzbereich)
[HH,F] = freqz(B,A,nfft,'whole',fs);
HH = 20*log10(abs(HH));               % Betrag des LPC-Spektrums in dB 


%  Spektren zeichnen 
%--------------------------------------------------------------------------

figure(signum)
clf

legendstr = {};
if exist('power_spec') 
  plot((0:nfft/2-1)/nfft*fs,power_spec(1:nfft/2));   % Leistungsdichtespektrum
  legendstr{end+1} = 'Fourierspektrum';
end
hold on;

if exist('smspec') 
  plot(F(1:nfft/2),smspec(1:nfft/2),'-r');           % geglaettetes Spektrum
  legendstr{end+1} = 'gegl. Fourierspektrum';
end

plot(F(1:nfft/2),HH(1:nfft/2),'-k');               % LPC-Spektrum
legendstr{end+1} = ['LPC' num2str(order) '-Spektrum'];

hold off;
set(gca,'box','on');
set(gca,'ylim',[-70 0]);
ylabel('Betrag in dB');
legend(legendstr);
if signum == 1
  str = '  (Maennerstimme)';
else
  str = '  (Frauenstimme)';
end
title(['Spektren des Lautes [i]' str]);

