function r = acf(x,nr)
%
%  function:  r = acf(x,nr)
%
%  Compute autocorrelation coefficients `r` from signal vector `x`
%          
%  Inputs:   x   signal vector 
%            nr  number of autocorrelation coeffs to be computed (0..nr)
%
%  Output:   r   vector of autocorrelation coeffs (size = nr+1)

%                                                            BP  03-09-1998

x = x(:);   % make column vector
len = length(x);

r = zeros(nr+1,1);
for i = 0:nr,
   r(i+1) = x(1:len-i)' * x(1+i:len);
end
