function t = phone_has_properties (F,property)
%
% t = phone_has_properties(F,property);
%
% Teste die Trainingslaute auf die Eigenschaft 'property'.
%
% Possible properties are: 
%        'vowel'                (Vokal)
%        'long_vowel'           (Langvokal)
%        'short_vowel'          (Kurzvokal)
%        'open_vowel'           (offener Vokal)
%        'close_vowel'          (geschlossener Vokal)
%        'front_vowel'          (vorn artikulierter Vokal)
%        'diphthong'            (Diphthong)
%        'consonant'            (Konsonant)
%        'fricative'            (Frikativ)
%        'nasal'                (Nasallaut)
%        'plosive'              (Plosivlaut)
%        'nucleus'              (Nukleus)
%        'jlr'                  (Einer der Laute [j], [l] oder [r])
%        'schwa'                (Schwa)
%        'voiced'               (Stimmhaft)   
%        'unvoiced'             (Stimmlos)
%        'preplosive_pause'     (praeplosive Pause)
%        'accent_0'             (kein Akzent / unakzentuiert)             
%        'accent_1'             (Akzent 1. Grades / Hauptakzent
%        'accent_2'             (Akzent 2. Grades)
%        'accent_3'             (Akzent 3. Grades)
%        'accent_4'             (Akzent 4. Grades)
%        'phrase_bnd_0'         (es folgt eine 0 Phrasengrenze, Satzgrenze) 
%        'phrase_bnd_1'         (es folgt eine 1 Phrasengrenze)
%        'phrase_bnd_2'         (es folgt eine 2 Phrasengrenze)
%        'no_phrase_bnd'        (es folgt keine Phrasengrenze)
%        'terminal_phrase'      (terminale Phrase)
%        'progredient_phrase'   (progrediente Phrase)
%        'syllable_size_1'      (Silbengroesse: 1 Laut)
%        'syllable_size_2'      (Silbengroesse: 2 Laute)
%        'syllable_size_3'      (Silbengroesse: 3 Laute)    
%        'syllable_size_4'      (Silbengroesse: 4 Laute)    
%        'syllable_size_5'      (Silbengroesse: 5 Laute)    
%        'syllable_size_6'      (Silbengroesse: 6 Laute)    
%        'syllable_size_7'      (Silbengroesse: 7 Laute)        
%        'syllable_size_gt_7'   (Silbengroesse: mehr als 7 Laute)
%
%        'previous_phone_is_vowel'       Eigenschaften der vorangehenden Laute
%        'previous_phone_is_long_vowel'          
%        'previous_phone_is_short_vowel'          
%        'previous_phone_is_diphthong'          
%        'previous_phone_is_nucleus'          
%        'previous_phone_is_consonant'          
%        'previous_phone_is_fricative'          
%        'previous_phone_is_nasal'          
%        'previous_phone_is_plosive'          
%        'previous_phone_is_jlr'          
%        'previous_phone_is_unvoiced'          
%        'previous_phone_is_voiced'          
%        'phone_is_after_preplosive_pause'
%          
%        'next_phone_is_vowel'           Eigenschaften der nachfolgenden Laute
%        'next_phone_is_long_vowel'          
%        'next_phone_is_short_vowel'          
%        'next_phone_is_diphthong'          
%        'next_phone_is_nucleus'          
%        'next_phone_is_consonant'          
%        'next_phone_is_fricative'          
%        'next_phone_is_nasal'          
%        'next_phone_is_plosive'          
%        'next_phone_is_jlr'          
%        'next_phone_is_unvoiced'          
%        'next_phone_is_voiced'          
%        'phone_is_before_preplosive_pause' 


PropertiesForStruct = {'vowel'; 'long_vowel'; 'open_vowel'; 'close_vowel'; 'front_vowel'; 'short_vowel'; 'diphthong'; 'nucleus'; ...
     'consonant'; 'fricative'; 'nasal'; 'plosive'; 'jlr'; 'schwa'; ...
     'voiced'; 'unvoiced'; 'preplosive_pause'; ...
     'phrase_bnd_0'; 'phrase_bnd_1'; 'phrase_bnd_2'; 'no_Phrase_bnd'; ...
     'accent_0'; ...
     'accent_1'; ...
     'accent_2'; ...
     'accent_3'; ...     
     'accent_4'; ...    
     'phrase_bnd_0'; ...    
     'phrase_bnd_1'; ...    
     'phrase_bnd_2'; ...    
     'no_phrase_bnd'; ...    
     'terminal_phrase'; ...
     'progredient_phrase'; ...
     'syllable_position_offset'; ...
     'syllable_position_nucleus'; ...
     'syllable_position_coda'; ...
     'syllable_size_1'; ...
     'syllable_size_2'; ...
     'syllable_size_3'; ...
     'syllable_size_4'; ...
     'syllable_size_5'; ...
     'syllable_size_6'; ...
     'syllable_size_7'; ...    
     'syllable_size_gt_7'; ...
     'previous_phone_is_vowel'; ...
     'previous_phone_is_long_vowel'; ...
     'previous_phone_is_short_vowel'; ...
     'previous_phone_is_diphthong'; ...
     'previous_phone_is_nucleus'; ...
     'previous_phone_is_consonant'; ...
     'previous_phone_is_fricative'; ...
     'previous_phone_is_nasal'; ...
     'previous_phone_is_plosive'; ...
     'previous_phone_is_jlr'; ...
     'previous_phone_is_unvoiced'; ...
     'previous_phone_is_voiced'; ...
     'phone_is_after_preplosive_pause'; ...
     'next_phone_is_vowel'; ...
     'next_phone_is_long_vowel'; ...
     'next_phone_is_short_vowel'; ...
     'next_phone_is_diphthong'; ...
     'next_phone_is_nucleus'; ...
     'next_phone_is_consonant'; ...
     'next_phone_is_fricative'; ...
     'next_phone_is_nasal'; ...
     'next_phone_is_plosive'; ...
     'next_phone_is_jlr'; ...
     'next_phone_is_unvoiced'; ...
     'next_phone_is_voiced'; ...
     'phone_is_before_preplosive_pause';...
    };


PropertiesForChar = {'vowel'; 'long_vowel'; 'short_vowel';  'open_vowel'; 'close_vowel'; 'front_vowel'; 'diphthong'; 'nucleus'; ...
     'consonant'; 'fricative'; 'nasal'; 'plosive'; 'jlr'; 'schwa'; ...
     'voiced'; 'unvoiced'; 'preplosive_pause'; ...
     'phrase_bnd_0'; 'phrase_bnd_1'; 'phrase_bnd_2'; 'no_phrase_bnd'; ...
     'accent_0'; ...
     'accent_1'; ...
     'accent_2'; ...
     'accent_3'; ...     
     'accent_4'; ...    
     'phrase_bnd_0'; ...    
     'phrase_bnd_1'; ...    
     'phrase_bnd_2'; ...    
     'no_phrase_bnd'; ...    
     'terminal_phrase'; ...
     'progredient_phrase'; ...
     'syllable_position_offset'; ...
     'syllable_position_nucleus'; ...
     'syllable_position_coda'; ...
     'syllable_size_1'; ...
     'syllable_size_2'; ...
     'syllable_size_3'; ...
     'syllable_size_4'; ...
     'syllable_size_5'; ...
     'syllable_size_6'; ...
     'syllable_size_7'; ...    
     'syllable_size_gt_7'; ...
    };
  
        
if isstruct(F) && ~ismember(property,PropertiesForStruct), 
   error(['Invalid phone property <' char(property) '>!']);
end

if (ischar(F) || isnumeric(F) ) && ~ismember(property,PropertiesForChar), 
   error(['Invalid phone property <' char(property) '>!']);
end

if isstruct(F)
  if strmatch(property,'vowel'),
    t = isVow(F.phone_id);
  elseif strmatch(property,'long_vowel'),
    t = isLong(F.phone_id);
  elseif strmatch(property,'short_vowel'),
    t = isShort(F.phone_id);
  elseif strmatch(property,'open_vowel'),
    t = isOpenVow(F.phone_id);  
  elseif strmatch(property,'close_vowel'),
    t = isCloseVow(F.phone_id);
  elseif strmatch(property,'front_vowel'),
    t = isFrontVow(F.phone_id);        
  elseif strmatch(property,'diphthong'),
    t = isDiph(F.phone_id);
  elseif strmatch(property,'nucleus'),
    t = isNuc(F.phone_id);
  elseif strmatch(property,'consonant'),
    t = isCons(F.phone_id);
  elseif strmatch(property,'fricative'),
    t = isFricative(F.phone_id);
  elseif strmatch(property,'nasal'),
    t = isNasal(F.phone_id);
  elseif strmatch(property,'plosive'),
    t = isPlosive(F.phone_id);
  elseif strmatch(property,'jlr'),
    t = isOther(F.phone_id);
  elseif strmatch(property,'schwa'),
    t = isCentralVow(F.phone_id);
  elseif strmatch(property,'unvoiced'),
    t = isVoiceless(F.phone_id);
  elseif strmatch(property,'voiced'),
    t = ~isVoiceless(F.phone_id);
  elseif strmatch(property,'preplosive_pause'),
    t = isPreplosivePause(F.phone_id);


  elseif strcmp(property,'phrase_bnd_0') == 1
    t = isPhrBnd0(F.phrase_boundary);
  elseif strcmp(property,'phrase_bnd_1') == 1
    t = isPhrBnd1(F.phrase_boundary);
  elseif strcmp(property,'phrase_bnd_2') == 1
    t = isPhrBnd2(F.phrase_boundary);  
  elseif strcmp(property,'no_phrase_bnd') == 1
    t = isNoPhrBnd(F.phrase_boundary); 
  elseif strcmp(property,'accent_0') == 1
    t = F.accent == 0;    
  elseif strcmp(property,'accent_1') == 1
    t = F.accent == 1;   
  elseif strcmp(property,'accent_2') == 1
    t = F.accent == 2;  
  elseif strcmp(property,'accent_3') == 1
    t = F.accent == 3;  
  elseif strcmp(property,'accent_4') == 1
    t = F.accent == 4;  

    % phrase type
  elseif strcmp(property, 'terminal_phrase') ==1
    t = ismember(F.phrase_type, 'T');
  elseif strcmp(property, 'progredient_phrase') ==1
    t = ismember(F.phrase_type, 'P');  

   % syllable size
  elseif strcmp(property, 'syllable_size_1') == 1
    t = hasSyllableSize(F.syllable_size, 1);
  elseif strcmp(property, 'syllable_size_2') == 1
    t = hasSyllableSize(F.syllable_size, 2);  
  elseif strcmp(property, 'syllable_size_3') == 1
    t = hasSyllableSize(F.syllable_size, 3);
  elseif strcmp(property, 'syllable_size_4') == 1
    t = hasSyllableSize(F.syllable_size, 4);
  elseif strcmp(property, 'syllable_size_5') == 1
    t = hasSyllableSize(F.syllable_size, 5); 
  elseif strcmp(property, 'syllable_size_6') == 1
    t = hasSyllableSize(F.syllable_size, 6);
  elseif strcmp(property, 'syllable_size_7') == 1
    t = hasSyllableSize(F.syllable_size, 7);  
  elseif strcmp(property, 'syllable_size_gt_7') == 1
    t = hasSyllableSizeGT7(F.syllable_size);  


    % properties of preceding phone
  elseif strmatch(property,'previous_phone_is_vowel'),
    t = isVow(F.phone_id);
    t = [0; t(1:end-1)];
  elseif strmatch(property,'previous_phone_is_long_vowel'),
    t = isLong(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_short_vowel'),
    t = isShort(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_diphthong'),
    t = isDiph(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_nucleus'),
    t = isNuc(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_consonant'),
    t = isCons(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_fricative'),
    t = isFricative(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_nasal'),
    t = isNasal(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_plosive'),
    t = isPlosive(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_jlr'),
    t = isOther(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_unvoiced'),
    t = isVoiceless(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'previous_phone_is_voiced'),
    t = ~isVoiceless(F.phone_id);
    t = [0; t(1:end-1)];  
  elseif strmatch(property,'phone_is_after_preplosive_pause'),
    t = isPreplosivePause(F.phone_id);
    t = [0; t(1:end-1)];  



      % properties of following phone
  elseif strmatch(property,'next_phone_is_vowel'),
    t = isVow(F.phone_id);
    t = [t(2:end); 0];
  elseif strmatch(property,'next_phone_is_long_vowel'),
    t = isLong(F.phone_id);
    t = [t(2:end); 0];
  elseif strmatch(property,'next_phone_is_short_vowel'),
    t = isShort(F.phone_id);
    t = [t(2:end); 0]; 
  elseif strmatch(property,'next_phone_is_diphthong'),
    t = isDiph(F.phone_id);
    t = [t(2:end); 0];
  elseif strmatch(property,'next_phone_is_nucleus'),
    t = isNuc(F.phone_id);
    t = [t(2:end); 0]; 
  elseif strmatch(property,'next_phone_is_consonant'),
    t = isCons(F.phone_id);
    t = [t(2:end); 0];
  elseif strmatch(property,'next_phone_is_fricative'),
    t = isFricative(F.phone_id);
    t = [t(2:end); 0];
  elseif strmatch(property,'next_phone_is_nasal'),
    t = isNasal(F.phone_id);
    t = [t(2:end); 0]; 
  elseif strmatch(property,'next_phone_is_plosive'),
    t = isPlosive(F.phone_id);
    t = [t(2:end); 0];
  elseif strmatch(property,'next_phone_is_jlr'),
    t = isOther(F.phone_id);
    t = [t(2:end); 0]; 
  elseif strmatch(property,'next_phone_is_unvoiced'),
    t = isVoiceless(F.phone_id);
    t = [t(2:end); 0]; 
  elseif strmatch(property,'next_phone_is_voiced'),
    t = ~isVoiceless(F.phone_id);
    t = [t(2:end); 0];
  elseif strmatch(property,'phone_is_before_preplosive_pause'),
    t = isPreplosivePause(F.phone_id);
    t = [t(2:end); 0];       
  else
     error(['*** Invalid phone property:  <' char(property) '>!']);
  end

elseif ischar(F) 
  %% F is a character of character array
  
  if strmatch(property,'vowel'),
    t = isVow(F);
  elseif strmatch(property,'long_vowel'),
    t = isLong(F);
  elseif strmatch(property,'short_vowel'),
    t = isShort(F);
  elseif strmatch(property,'open_vowel'),
    t = isOpenVow(F);    
  elseif strmatch(property,'close_vowel'),
    t = isCloseVow(F); 
  elseif strmatch(property,'front_vowel'),
    t = isFrontVow(F);         
  elseif strmatch(property,'diphthong'),
    t = isDiph(F);
  elseif strmatch(property,'nucleus'),
    t = isNuc(F);
  elseif strmatch(property,'consonant'),
    t = isCons(F);
  elseif strmatch(property,'fricative'),
    t = isFricative(F);
  elseif strmatch(property,'nasal'),
    t = isNasal(F);
  elseif strmatch(property,'plosive'),
    t = isPlosive(F);
  elseif strmatch(property,'jlr'),
    t = isOther(F);
  elseif strmatch(property,'schwa'),
    t = isCentralVow(F);
  elseif strmatch(property,'unvoiced'),
    t = isVoiceless(F);
  elseif strmatch(property,'voiced'),
    t = ~isVoiceless(F);
  elseif strmatch(property,'preplosive_pause'),
    t = isPreplosivePause(F);

  % phrase boundary
  elseif strcmp(property,'phrase_bnd_0') == 1
    t = isPhrBnd0(F);
  elseif strcmp(property,'phrase_bnd_1') == 1
    t = isPhrBnd1(F);
  elseif strcmp(property,'phrase_bnd_2') == 1
    t = isPhrBnd2(F);  
  elseif strcmp(property,'no_phrase_bnd') == 1
    t = isNoPhrBnd(F); 


    % phrase type
  elseif strcmp(property, 'terminal_phrase') ==1
    t = ismember(F, 'T');
  elseif strcmp(property, 'progredient_phrase') ==1
    t = ismember(F, 'P');  

   % syllable size
  elseif strcmp(property, 'syllable_size_1') == 1
    t = hasSyllableSize(F, 1);
  elseif strcmp(property, 'syllable_size_2') == 1
    t = hasSyllableSize(F, 2);  
  elseif strcmp(property, 'syllable_size_3') == 1
    t = hasSyllableSize(F, 3);
  elseif strcmp(property, 'syllable_size_4') == 1
    t = hasSyllableSize(F, 4);
  elseif strcmp(property, 'syllable_size_5') == 1
    t = hasSyllableSize(F, 5); 
  elseif strcmp(property, 'syllable_size_6') == 1
    t = hasSyllableSize(F, 6);
  elseif strcmp(property, 'syllable_size_7') == 1
    t = hasSyllableSize(F, 7);  
  elseif strcmp(property, 'syllable_size_gt_7') == 1
    t = hasSyllableSizeGT7(F);  
  end
  
elseif isnumeric(F)
  if strcmp(property,'accent_0') == 1
    t = F == 0;    
  elseif strcmp(property,'accent_1') == 1
    t = F == 1;   
  elseif strcmp(property,'accent_2') == 1
    t = F == 2;  
  elseif strcmp(property,'accent_3') == 1
    t = F == 3;  
  elseif strcmp(property,'accent_4') == 1
    t = F == 4;  
  end
  
else
  error(['*** Invalid input format!']);
end




%================= local functions =====================================

function n = isBackVow(s)
%  
% n = isBackVow(s);
%
% Return 1 if 's' is a back vowel or a back-closing diphthong. Otherwise 0.
  
phs = { 'u' 'u:' 'U' 'o' 'o:' 'O' 'a_u' };

n = ismember(s,phs);
  

function n = isCentralVow(s)
%  
% n = isCentralVow(s);
%
% Return 1 if 's' is a central vowel. Otherwise 0.
  
phs = { '@' '6' };
		  
n = ismember(s,phs);


function n = isCloseVow(s)
%  
% n = isCloseVow(s);
%
% Return 1 if 's' is a close vowel. Otherwise 0.
  
phs = { 'i' 'i:' 'I' 'Y' 'y' 'y:' 'U' 'u' 'u:' };
	 
n = ismember(s,phs);


function n = isCons (s)
%  
% n = isCons(s);
%
% Return 1 if 's' is a consonant. Otherwise 0.
  
phs = { 'C' 'N' 'S' 'b' 'd' 'f' 'g' 'h' 'j' 'k' 'l' 'm' ...
	'n' 'p' 'r' 's' 't' 'v' 'x' 'z' ...
        'p_f' 't_s' 't_S' }; 

n = ismember(s,phs);



function n = isDiph(s)
%  
% n = isDiph(s);
%
% Return 1 if 's' is a diphthong. Otherwise 0.
  
phs = { 'O_y' 'a_i' 'a_u' };

n = ismember(s,phs);


function n = isFricative (s)
%  
% n = isFricative(s);
%
% Return 1 if 's' is a consonant. Otherwise 0.
  
phs = { 'f' 'v' 's' 'z' 'S' 'C' 'x' 'h' }; 

n = ismember(s,phs);


function n = isFrontVow(s)
%  
% n = isFrontVow(s);
%
% Return 1 if 's' is a front vowel or a front-closing diphthong. Otherwise 0.
  
phs = { 'i' 'i:' 'I' 'Y' 'y' 'y:' 'e' 'e:' '2' '2:' 'E' 'E:' ...
		  '9' '9:' 'a' 'a:' 'O_y' 'a_i' };
	 
n = ismember(s,phs);


function n = isGlottal (s)
%  
% n = isGlottal(s);
%
% Return 1 if 's' is a glottal consonant. Otherwise 0.
  
phs = { '?' 'h' }; 

n = ismember(s,phs);


function n = isLateral (s)
%  
% n = isLateral(s);
%
% Return 1 if 's' is a lateral. Otherwise 0.
  
phs = { 'l' };
	 
n = ismember(s,phs);


function n = isLong(s);
%  
% n = isLong (s);
%
% Return 1 if 's' is a long vowel. Otherwise 0.
  
phs = { '2:' '9:' 'E:' 'a:' 'e:' 'i:' 'o:' 'u:' 'y:' };

n = ismember(s,phs);


function n = isMidVow(s)
%  
% n = isMidVow(s);
%
% Return 1 if 's' is a mid vowel. Otherwise 0.
  
phs = { 'e' 'e:' '2' '2:' '9' '9:' 'E' 'E:' '@' 'o' 'o:' 'O' };
	 
n = ismember(s,phs);


function n = isNasal (s)
%  
% n = isNasal(s);
%
% Return 1 if 's' is a nasal consonant. Otherwise 0.
  
phs = { 'm' 'n' 'N' };
	 
n = ismember(s,phs);

function n = isNuc(s)
%  
% n = isNuc (s);
%
% Return 1 if 's' is a syllable nucleus. Otherwise 0.
  
n = isVow(s);

function n = isOpenVow(s)
%  
% n = isOpenVow(s);
%
% Return 1 if 's' is an open vowel. Otherwise 0.
  
phs = { 'a' 'a:' '6' };
	 
n = ismember(s,phs);


function n = isOther (s)
%  
% n = isOther(s);
%
% Return 1 if 's' is 'j', 'l' or 'r'. Otherwise 0.
  
phs = { 'j' 'l' 'r' }; 

n = ismember(s,phs);


function n = isPalatal (s)
%  
% n = isPalatal(s);
%
% Return 1 if 's' is a palatal consonant. Otherwise 0.
  
phs = { 'C' }; 

n = ismember(s,phs);


function n = isPlosive (s)
%  
% n = isPlosive(s);
%
% Return 1 if 's' is a plosive. Otherwise 0.
  
phs = { '>' '?' 'b' 'd' 'g' 'k' 'p' 't' }; 

n = ismember(s,phs);

function n = isPostalveolar (s)
%  
% n = isPostalveolar(s);
%
% Return 1 if 's' is a postalveolar consonant. Otherwise 0.
  
phs = { 'S' }; 

n = ismember(s,phs);


function n = isPreplosivePause(s)
%  
% n = isPreplosivePause (s);
%
% Return 1 if 's' is a preplosive pause. Otherwise 0.
  
phs = { '>' };

n = ismember(s,phs);

function n = isShort(s)
%  
% n = isShort(s);
%
% Return 1 if 's' is a short vowel. Otherwise 0.
  
phs = { '2' '6' '9' '@' 'E' 'I' 'O' 'U' 'Y' 'a' 'e' 'i' 'o' 'u' 'y' };

n = ismember(s,phs);


function n = isTrill (s)
%  
% n = isTrill(s);
%
% Return 1 if 's' is a trill. Otherwise 0.
  
phs = { 'r' };
	 
n = ismember(s,phs);


function n = isVelar (s)
%  
% n = isVelar(s);
%
% Return 1 if 's' is a velar consonant. Otherwise 0.
  
phs = { 'k' 'g' 'N' 'x' }; 

n = ismember(s,phs);



function n = isVoiceless (s)
%  
% n = isVoiceless(s);
%
% Return 1 if 's' is a voiceless consonant. Otherwise 0.
  
phs = { 'p' 't' 'k' 'f' 's' 'S' 'C' 'x' };
	 
n = ismember(s,phs);


function n = isVow(s)
%  
% n = isVow(s);
%
% Return 1 if 's' is a vowel. Otherwise 0.
  
phs = { '2' '2:' '6' '9' '9:' '@' 'E' 'E:' 'I' 'O' 'O_y' 'U' 'Y' ...
        'a' 'a:' 'a_i' 'a_u' 'e' 'e:' 'i'  'i:' 'o' 'o:' 'u' 'u:' ...
        'y' 'y:' };

n = ismember(s,phs);


function n = isPhrBnd0(s)
%  
% n = isPhrBnd0 (s);
%
% Return 1 if 's' is a '0' phrase boundary. Otherwise 0.

phs = { '0' };
  
n = ismember(s,phs);

function n = isPhrBnd1(s)
%  
% n = isPhrBnd1 (s);
%
% Return 1 if 's' is a '1' phrase boundary. Otherwise 0.
  
phs = { '1' };
  
n = ismember(s,phs);


function n = isPhrBnd2(s)
%  
% n = isPhrBnd2 (s);
%
% Return 1 if 's' is a '2' phrase boundary. Otherwise 0.
  
phs = { '2' };
  
n = ismember(s,phs);

function n = isNoPhrBnd(s)
%  
% n = isPhrBnd2 (s);
%
% Return 1 if 's' is a no phrase boundary. Otherwise 0.
  
phs = { '-' };
  
n = ismember(s,phs);

function t = hasSyllableSize(all_syllable_sizes, syllable_size)
  t = zeros(size(all_syllable_sizes,1),1);
  t(find(all_syllable_sizes==syllable_size),1) = 1;

function t = hasSyllableSizeGT7(all_syllable_sizes)
  t = zeros(size(all_syllable_sizes,1),1);
  t(find(all_syllable_sizes>7),1) = 1;
