function  [elem_nam,dur,ffreq] = load_sigele_data(fln)
%
%  function:  [elem_nam,dur,ffreq] = load_sigele_data(fln)
%
%  Read signal element information (output of SVOX) from file `fln` and 
%  return it as three vectors. The i-th element of these vectors are:
%      
%    elem_nam(i)  name of the i-th signal element  
%    dur(i)       duration of the i-th signal element in msec
%    ffreq(i)     fundamental frequency of the i-th signal element in Hz

if exist(fln,'file') ~= 2,
  p = fullpath('ueb7_data');
  if isempty(p)
      error('ueb7_data could not be found');
  else
    fln = [p '/' fln];
  end
  if exist(fln,'file') ~= 2,
    error(['*** file not found:  ' fln])
  end
end

fid = fopen(fln,'r');
if fid == -1,
  error(['*** file not opened:  ' fln])
end

blnk = ['          '];
n = 1;

lin = fgetl(fid);
while lin ~= -1,
  [token,lin] = strtok(lin,' ');
  elem_nam(n,1:10) = [token blnk(length(token)+1:10)];
  [token,lin] = strtok(lin,' ');
  dur(n) = str2num(token);
  [token,lin] = strtok(lin,' ');
  ffreq(n) = str2num(token);
  n = n+1;
  lin = fgetl(fid);
end
  
fclose(fid);



