function  F = load_phonol_repr(syl,acc,lng,phr,bnd)
%
%  function:  F = load_phonol_repr(fln);
%
%  Read per syllable phonological information (normally loaded
%  with ptrread) and return for each phone
%  the linguistic factors in `F`.
%
%  Input:
%    see output of ptrread()
% 
%  Output:   
%    F   = factors struct with the following fields:
%          .phone_id:         phone identifier in ETHPA notation 
%          .phone_number:     the phone number (position) within a syllable    
%          .syllable_size:    the syllable size in number of phones
%          .phone_position:   position of the phone within its syllable:
%                             'a':  in syllable onset (Ansatz)
%                             'n':  in syllable nucleus (Nukleus)
%                             'k':  in syllable coda (Koda)
%          .accent:           accent or stress level of syllable: 0 ... 4
%                             0:  no stress 
%                             1:  main stress
%                             2:  secondary stress
%                             4:  weakest stress
%          .syllable_number:  syllable number within phase (using 0 and 1
%                             boundaries)   
%          .phrase_size:      number of syllables in phrase
%          .phrase_type:      phrase type:  'P' for progressive 
%                                           'T' for terminal (sentence-final)
%          .phrase_boundary:  phrase boundary after current syllable:        
%                             '-':  no phrase boundary
%                             '2':  weak phrase boundary
%                             '1':  strong phrase boundary
%                             '0':  sentence boundary
  
ind = 1;
ilastsyl = 1;
spp = [];
for i = 1:size(syl,1),
  %fprintf('%s \n',syl(i,:));
  s = syl(i,:);
  j = 1;
  while ~isempty(s)
    [ph,s] = nextphone(s);
    if ~isempty(ph),
                    % Einfuegen einer Pause nach 1 Phrasengrenze (siehe unten)
      if (ind > 1) & (j == 1) & ismember(F.phrase_boundary(ilastsyl),{'1'})
        spp = [spp ind];
      end
      % Einfuegen einer praeplosive Pause vor Plosivlauten (ausser nach Pause)
      if isPlosive(ph) & ...
         (ind > 1) & ismember(F.phrase_boundary(ilastsyl),{'-' '2'}),
        F.phone_id{ind} = '>';
        F.phone_number(ind) = j;
        F.syllable_number_sentence(ind) = i;
        F.accent(ind) = str2num(acc(i));
        F.phrase_type{ind} = phr(i,:);
         if strmatch('0',bnd(i,:),'exact'),
           F.phrase_boundary(ind) = '0';
         elseif strmatch('1',bnd(i,:),'exact'),
           F.phrase_boundary(ind) = '1';
         elseif strmatch('2',bnd(i,:),'exact'),
           F.phrase_boundary(ind) = '2';
         else
           F.phrase_boundary(ind) = '-';
         end
        %fprintf('%d %d %s %s %s %s \n',i,j,'>',acc(i),phr(i),bnd(i));
        ind = ind + 1;
        j = j + 1;
      end
      F.phone_id{ind} = ph(:)';
      F.phone_number(ind) = j;
      F.syllable_number_sentence(ind) = i;
      F.accent(ind) = str2num(acc(i,:));
      F.phrase_type{ind} = phr(i,:);
       if strmatch('0',bnd(i,:),'exact'),
         F.phrase_boundary(ind) = '0';
       elseif strmatch('1',bnd(i,:),'exact'),
         F.phrase_boundary(ind) = '1';
       elseif strmatch('2',bnd(i,:),'exact'),
         F.phrase_boundary(ind) = '2';
       else
         F.phrase_boundary(ind) = '-';
       end
      %fprintf('%d %d %s %s %s %s \n',i,j,ph(:),acc(i),phr(i),bnd(i));
      ind = ind + 1;
      j = j + 1;
    end
  end
  ilastsyl = ind-1;
end
F.syllable_number_sentence = F.syllable_number_sentence';
F.phone_number = F.phone_number';
F.phone_id = char(F.phone_id);
F.accent = F.accent';
F.phrase_type = char(F.phrase_type);
F.phrase_boundary = F.phrase_boundary';
  
% mark syllables with a, n, k
syls = find(F.phone_number == 1);
syle = [syls(2:end)-1; size(F.phone_number,1)];
syllen = F.phone_number(syle);
sylnuc = find(phone_has_properties(F, 'nucleus'));
for i = 1:length(syls),
  F.syllable_size(syls(i):syle(i)) = syllen(i);  
  F.phone_position(syls(i):sylnuc(i)-1) = 'a';
  F.phone_position(sylnuc(i)+1:syle(i)) = 'k';
  F.phone_position(sylnuc(i)) = 'n';
end
F.syllable_size = F.syllable_size';
F.phone_position = F.phone_position';

% compute phrase size
phre = find(ismember(F.phrase_boundary,{'0' '1'}) & ...
            F.phone_number == F.syllable_size);
phrs = [1; phre(1:end-1)+1];
phrlen = F.syllable_number_sentence(phre)-F.syllable_number_sentence(phrs)+1;
for i = 1:length(phrs),
  F.phrase_size(phrs(i):phre(i)) = phrlen(i);
end
F.phrase_size = F.phrase_size';

%% phrase size

% compute syllable number in phrase, using 0 and 1 phrase boundaries
%(instead of syllable number in sentence as given in the .dat file
syllable_number_in_phrase = zeros(size(F.syllable_number_sentence)); % preallocate for speedup
phrase_number = 1; % number of phrase in sentence
syllable_ends = find(F.phone_number == F.syllable_size);
phrase_boundaries0 = strmatch('0', F.phrase_boundary, 'exact');
phrase_boundaries1 = strmatch('1', F.phrase_boundary, 'exact');
phrase_boundaries = intersect(syllable_ends, union(phrase_boundaries0, phrase_boundaries1));
phrase_boundaries = [0; phrase_boundaries]; % Indexes of last phone of every phrase
% look at every phrase and adjust syllable number if necessary
for i = 1:length(phrase_boundaries)-1
  if phrase_number == 1    % first phrase in a sentence
    syllable_number_in_phrase(phrase_boundaries(i)+1:phrase_boundaries(i+1)) = ...
        F.syllable_number_sentence(phrase_boundaries(i)+1:phrase_boundaries(i+1));
  else % later phrases in a sentence
    syllable_number_in_phrase(phrase_boundaries(i)+1:phrase_boundaries(i+1)) = ...
      F.syllable_number_sentence(phrase_boundaries(i)+1:phrase_boundaries(i+1)) - F.syllable_number_sentence(phrase_boundaries(i));
  end
  phrase_number = phrase_number + 1;
   % if we are at the end of a sentence, reset phrase counting 
  if strcmp(F.phrase_boundary(phrase_boundaries(i+1)), '0')
    phrase_number = 1;
  end
end
F.syllable_number = syllable_number_in_phrase;



% Einfuegen von Pausen 
if ~isempty(spp)
  for ii = 1:length(spp)
    F.phone_id(end+1:-1:spp+1,:) = F.phone_id(end:-1:spp,:); 
    F.phone_number(end+1:-1:spp+1) = F.phone_number(end:-1:spp); 
    F.syllable_number(end+1:-1:spp+1) = F.syllable_number(end:-1:spp); 
    F.accent(end+1:-1:spp+1) = F.accent(end:-1:spp); 
    F.phrase_type(end+1:-1:spp+1) = F.phrase_type(end:-1:spp); 
    F.phrase_boundary(end+1:-1:spp+1) = F.phrase_boundary(end:-1:spp); 
    F.syllable_size(end+1:-1:spp+1) = F.syllable_size(end:-1:spp); 
    F.phone_position(end+1:-1:spp+1) = F.phone_position(end:-1:spp); 
    F.phrase_size(end+1:-1:spp+1) = F.phrase_size(end:-1:spp); 
    F.phone_id(spp,1:3) = '/  ';
    F.phone_number(spp) = 0;
    F.syllable_number(spp) = 0;
    F.accent(spp) = 0;
    F.phrase_type(spp) = '-';
    F.phrase_boundary(spp) = '-';
    F.syllable_size(spp) = 0;
    F.phone_position(spp) = '-';
    F.phrase_size(spp) = 0;
    spp(1) = [];
  end
end


%=============== local functions =============================


function n = isPlosive (s)
%  
% n = isPlosive(s);
%
% Return 1 if 's' is a plosive or affricate. Otherwise 0.
  
phs = { 'b' 'd' 'g' 'k' 'p' 't' 'p_f' 't_s' 't_S' }; 

n = ismember(s,phs);







