function [sdiph sdiphind] = get_semidiphones (phseq,ref_sdiph)
% 
%  [sdiph phind] = get_semidiphones(phseq);
% 
%  Get semidiphone sequence 'sdiph' given the phone sequence `phseq`. 
%  `sdiphind` indicates the phone this diphone is related to.
%
%  The optional input argument `ref_sdiph` is used to check, if the 
%  generated sequence `sdiph` is correct

diph.ph =  { 'a_u' 'a_i' 'O_y' 'p_f' 't_s' 't_S' };
diph.pha = { 'a'   'a'   'O'   'p'   't'   't' };
diph.phb = { 'u'   'i'   'y'   'f'   's'   'S' };

phind = [];
ind = 1;

%phseq = strvcat('\',phseq);
clear phseq2;
phseq = strvcat(phseq,'\');
for i = 1:length(phseq)
                         % replace diphthongs and affricates by vowel sequence
  diphi = find(strcmp(phseq(i,:),diph.ph)==1);
  if ~isempty(diphi)
    phseq2(ind) = diph.pha(diphi);
    phind(ind) = i;
    ind = ind + 1;
    phseq2(ind) = diph.phb(diphi);
    phind(ind) = i;
    ind = ind + 1;
  else
	                                    % remove 'long' marker
    phseq2(ind) = cellstr(regexprep(phseq(i),':',''));  
    phind(ind) = i;
    ind = ind + 1;
  end
end
phseq = char(phseq2);

sdiph = [];
sdiphind = [];
ind = 1;
for i = 1:length(phseq)-1 
  pha = phseq(i);  
  phb = phseq(i+1); 
  
  if ismember(pha,'>')
    sdiph{ind} = sprintf('^\\');
    sdiphind(ind) = phind(i);
    ind = ind+1;
  elseif ismember(pha,{ '/' })
    sdiph{ind} = sprintf('^\\');
    sdiphind(ind) = phind(i);
    ind = ind+1;
    if ~isPlosive(phb)
      sdiph{ind} = sprintf('\\%s',phb);
      sdiphind(ind) = phind(i);
      ind = ind+1;
    end
  elseif ismember(pha,{ '?' '\' })
    sdiph{ind} = sprintf('^\\');
    sdiphind(ind) = phind(i);
    ind = ind+1;
    sdiph{ind} = sprintf('\\%s',phb);
    sdiphind(ind) = phind(i);
    ind = ind+1;
  elseif ismember(phb,{ '>' '\' '?' '/' })
    if (i+1 == size(phseq,1))
      sdiph{ind} = sprintf('%s\\',pha);
    else
      sdiph{ind} = sprintf('%s>',pha);
    end 
    sdiphind(ind) = phind(i);
    ind = ind+1;
  else
    if (ind == 1) & ~isPlosive(pha) 
      sdiph{ind} = sprintf('\\%s',pha);
      sdiphind(ind) = phind(i);
      ind = ind+1;
    end
    sdiph{ind} = sprintf('%s%s.a',pha,phb);
    sdiphind(ind) = phind(i);
    ind = ind+1;
    sdiph{ind} = sprintf('%s%s.b',pha,phb);
    sdiphind(ind) = phind(i+1);
    ind = ind+1;
  end
  if ind > 2 && strcmp(sdiph{ind-2},'nn.a')   % replace some non-existant semi-diphones
    sdiph{ind-2} = 'nm.a';
    sdiph{ind-1} = 'nm.b';
  end
end

sdiph = sdiph';
sdiphind = sdiphind';

% test if semidiphone sequence correspondes to the reference 
% sequence `ref_sdiph` from the sigele file 

if nargin == 2
  for ii = 1:min(size(sdiph,1),size(ref_sdiph,1))  
    if ~strcmp(sdiph{ii},cellstr(ref_sdiph(ii,:))) & ...
       (~ismember(sdiph{ii}(2),{ '>' '\' }) | ...
        ~ismember(ref_sdiph(ii,2),{ '>' '\' }))  
      for i = 1:min(size(sdiph,1),size(ref_sdiph,1))
        if i == ii
          str = '  <===';
        else 
          str = '';
        end  
        fprintf('%s \t%s  %s \n',sdiph{i},ref_sdiph(i,:),str);
      end
      error(['*** sequences of semidiphones and sigele differ!'])
    end
  end
end


%=============== local functions =============================

function n = isPlosive(s)
  
% n = isPlosive(s);
%
% Return 1 if 's' is a plosive or affricate. Otherwise 0.
 
phs = { '?' 'b' 'd' 'g' 'k' 'p' 't' 'p_f' 't_s' 't_S' }; 

n = ismember(s,phs);


