function [sig,voicing] = get_corp_elem(name,ovl);
%
%  function [sig,voicing] = get_corp_elem(name,ovl);
%
%  Returns diphone or semi-diphone element 'name' as signal data
%  'sig'; the voicing state for the entire element is returned
%  as 'voicing' = 0 (unvoiced) or 'voicing' = 1 (voiced);
%  the returned signal is larger than the actual element 
%  by 'ovl' samples (ovl/2 additional samples are returnded before 
%  and after the element); 'ovl' should be set to the length of
%  the analysis window overlap;

corp_sig_file = 'ueb7_corp.wav';    % wave file holding corpus signal

global elelab;   % global variable defining element labels

if isempty(elelab)                  % load label file
  load ueb7_corp.lab.mat; 
  elelab = sdlab;
end

name = deblank(name);
ii = 0;                    % search element in corpus element list
while 1
  ii = ii+1;
  if ii > length(elelab)
    error(['*** element "' name '" not found in corpus "' corp_sig_file '"']) 
  end
  if strcmp(name,deblank(elelab(ii).name))
    break
  end
end
                                               % read element signal
sig = audioread(corp_sig_file, ...
           [elelab(ii).strt-ceil(ovl/2) elelab(ii).endp+ceil(ovl/2)]);  

                       % get phone which determines voicing state of element
if length(name) == 2
  if name(1) == '\'
    phone = name(2);
  else
    phone = name(1);
  end
elseif length(name) == 4
  if name(4) == 'a'
    phone = name(1);
  else
    phone = name(2);
  end
else
  error(['*** this is not a regular element name:  "' name '"'])
end
                                     % build list of voiced phones 
voicedph = strvcat('2','9','@','E','I','N','O','U','Y','a','e','i','j');
voicedph = strvcat(voicedph,'l','m','n','o','r','u','v','y','z');

                                     % get voicing state of phone
voicing = 0;                         % unvoiced by default
ind = strmatch(phone,voicedph,'exact');
if length(ind) > 0,
  voicing = 1;
end;
