function fp = fullpath(rp,ft)
%
% fp = fullpath(rp);
%
% Search MATLAB path for a completion of relative path 'rp' to a full path
% and returns the first existing full path 'fp'.
%
% fp = fullpath(rp,'file');
%
% Search MATLAB path for a completion of relative filename or path 'rp' to a
% full filename or path and returns the first existing full filename or path
% 'fp'.
    
if nargin<2,
  ft = 'dir';
end
  
if exist(fullfile(pwd,rp),ft),
  fp = rp;
  return;
end
p = path();
ip = find(p==':');
ps = [1; ip'+1];
pe = [ip'-1; length(p)];
for i = 1:length(ps),
  fp = [p(ps(i):pe(i)) '/' rp];
  if exist(fp,ft),
    return;
  end
end
fp = ''; % no full path found  
