function  f0_histogram(property)
%
%  function:  f0_histogram(property) 
%
%  Erstellt je ein Histogramm der Grundfrequenz von Silben oder
%  Phrasen, welche die Eigenschaft `property` haben bzw. nicht
%  haben. Als Eigenschaften koennen beliebige Eigenschaften der 
%  Funktion syllable_has_properties verwendet werden. 
%
%  Beispiele:   f0_histogram('accent_1'); 
%               f0_histogram('nucleus_long_vowel');
%               f0_histogram('terminal_phrase');
%
%
%  Fuer weitere moegliche Eigenschaften siehe:
%               help syllable_has_properties
%


if nargin == 0 
  help f0_histogram
  return
end




%   Trainingsdaten laden (aus Mat-Datei oder Text-Datei)
%---------------------------------------------------------------
%
corpfln = ['training_data.dat'];
disp('Laden der Trainingsdaten ... ');
if exist('.dur_train_data.mat', 'file'),
  load('.dur_train_data.mat');
else
  disp('(dauert etwa eine Minute!)')
  [F,d, f0] = load_training_data(corpfln);
  save('.dur_train_data.mat','F','d','f0');
end



%        Abweichung von der geschaetzten Deklination F_e
% ------------------------------------------------------------------------
%
derivation_values  = compute_declination_and_derivation(F, f0);
nucleus_indexes = find(phone_has_properties(F, 'nucleus')); 
derivation_values_for_syllables = derivation_values(nucleus_indexes);

% Lautverteilung fuer Silbenkerne mit der Eigenschaft 'property'
property_true = syllable_has_properties(F, property);
[n, xcenters] = hist(derivation_values_for_syllables, 10);
if (xcenters(end) - xcenters(1) < 1)
  xcenters = xcenters * 5;
end  
[n, xcenters] = hist(derivation_values_for_syllables(property_true == 1), xcenters);
buckets(:,1) = n / sum(property_true);
% Lautverteilung der komplementaeren Silbenkerne 
n = hist(derivation_values_for_syllables(property_true == 0), xcenters);
buckets(:,2) = n / (length(property_true) - sum(property_true));


%
% Darstellung des Histogramms
% 
f = figure(3);
pos = get(f, 'Position');
if pos(3) == 560 && pos(4) == 420
  % if default sizes, resize 
  set(f, 'Position', [pos(1), pos(2), 560, 800]);
end
subplot(3, 1, 1);
h = bar(xcenters, buckets);
hh = legend(h, {['Silben mit der Eigenschaft ''' property ''''], ...
                ['Silben ohne der Eigenschaft ''' property '''']});
set(hh,'interpreter','none');
xlabel(gca, '[Hz]');
title('Abweichung von der geschaetzten Deklinationsgerade: F_e');
colormap summer;




%                Grundfrequenz am Anfang der Deklinationsgeraden F_a
% ------------------------------------------------------------------------
%

% Indexe der ersten Silbenkerne aller Phrasen
phrase_start_indexes = find(F.syllable_number == 1);
nucleus_indexes = find(phone_has_properties(F, 'nucleus')); 
phrase_start_indexes_syllables = intersect(phrase_start_indexes, nucleus_indexes);

f0_at_phrase_starts = getPhraseStartIndexes(f0, ...
                        phrase_start_indexes_syllables, nucleus_indexes);  

% alle Indexe mit den gewuenschten Eigenschaften geschnitten mit
% den ersten Phrasensilben
property_indexes = syllable_has_properties(F, property) == 1; 
complementary_property_indexes = syllable_has_properties(F, property) == 0; 


disp(['Verteilung der Exemplare mit/ohne der Eigenschaft ''' property ...
      ''':  ' num2str(sum(property_indexes)) '/' ...
  num2str(sum(complementary_property_indexes))]);

clear buckets;
[n, xcenters] = hist(f0_at_phrase_starts, 10);
[n, xcenters] = hist(f0_at_phrase_starts(property_indexes), xcenters);
% Normalisierung mit der Anzahl der betreffenden Silben
buckets(:,1) = n / sum(property_indexes); 

% Lautverteilung der komplementaeren Silbenkerne 
n = hist(f0_at_phrase_starts(complementary_property_indexes), xcenters);
buckets(:,2) = n / sum(complementary_property_indexes); 

subplot(3, 1, 2);
h = bar(xcenters, buckets);
title('Grundfrequenz am Anfang der Deklinationsgerade: F_a');    
hh = legend(h, {['Silben mit der Eigenschaft ''' property ''''], ...
                ['Silben ohne die Eigenschaft ''' property '''']});
set(hh,'interpreter','none');
xlabel(gca, '[Hz]');
colormap summer;





%                Deklination F_d
% ------------------------------------------------------------------------
%


[derivation_values, declination_values] = compute_declination_and_derivation(F, f0);
declination_values_for_syllables = declination_values(nucleus_indexes);
clear buckets;
declination_values_for_properties = declination_values_for_syllables(property_true == 1); 
declination_values_for_non_properties = declination_values_for_syllables(property_true == 0);
[n, xcenters] = hist(declination_values, 10);
if xcenters(end) - xcenters(1) >= 45
  xcenters = xcenters / 2;
end
[n, xcenters] = hist(declination_values_for_properties, xcenters);
buckets(:,1) = n / sum(property_true);
% Lautverteilung der komplementaeren Silbenkerne 
n = hist(declination_values_for_non_properties, xcenters);
buckets(:,2) = n / (length(property_true) - sum(property_true));



subplot(3, 1, 3);
h = bar(xcenters, buckets);
title('Steigung der Deklinationsgerade: F_d ');    
hh = legend(h, {['Silben mit der Eigenschaft ''' property ''''], ...
                ['Silben ohne die Eigenschaft ''' property '''']});
set(hh,'interpreter','none');
xlabel(gca, 'Steigung in Hz/Silbe');
colormap summer;






%
% Berechnung der Fisher-Distanzen
% 
fdist = (mean(derivation_values_for_syllables(property_true == 1))-mean(derivation_values_for_syllables(property_true == 0))).^2 / ...
        (var(derivation_values_for_syllables(property_true == 1))+var(derivation_values_for_syllables(property_true == 0)));
disp(['Mass (Fisher-Distanz) fuer die Staerke der Eigenschaft ''' property '''']) 
disp([' - bezueglich der Abweichung von den Deklinationsgeraden:  ' ...
      num2str(fdist)])    
    

fdist = (mean(f0_at_phrase_starts(property_indexes))-mean(f0_at_phrase_starts(complementary_property_indexes))).^2 / ...
        (var(f0_at_phrase_starts(property_indexes))+var(f0_at_phrase_starts(complementary_property_indexes)));
disp([' - bezueglich der Anfangsfrequenz der Deklinationsgeraden:  ' ...
      num2str(fdist)])


fdist = (mean(declination_values_for_properties)-mean(declination_values_for_non_properties)).^2 / ...
        (var(declination_values_for_properties)+var(declination_values_for_non_properties));
disp([' - bezueglich der Steigung der Deklinationsgeraden:  ' ...
      num2str(fdist)])
    
    
    
function y = getPropertyPhraseStartIndexes(x1, x2)
  y = [];
  j = 1;
  for i = 1:length(x1)-1
    if x1(i) <= x2(j) && x2(j) <= x1(i+1)
      y = [y x1(i)];
      j = j + 1;
      while j <= length(x2) && x2(j) < x1(i+1)
        j = j + 1;
      end
      if j > length(x2)
        break;
      end
    end
  end
  

function f0_at_phrase_starts = getPhraseStartIndexes(f0, phrase_start_indexes, nucleus_indexes)
  f0_at_phrase_starts = [];
  phrase_start_indexes = [phrase_start_indexes; nucleus_indexes(end) + 1];
  for i = 1:length(phrase_start_indexes) - 1
    nucleus_indexes_in_phrase = nucleus_indexes(nucleus_indexes >= phrase_start_indexes(i) & nucleus_indexes < phrase_start_indexes(i+1));
    f0_for_nucleus_indexes_in_phrase = zeros(size(nucleus_indexes_in_phrase));
    f0_for_nucleus_indexes_in_phrase = f0_for_nucleus_indexes_in_phrase + f0(phrase_start_indexes(i)); 
    f0_at_phrase_starts = [f0_at_phrase_starts; f0_for_nucleus_indexes_in_phrase];
  end
  


  
  
  
  
  
  
  
  
  
  
  
  
  

