function  dispF(F,idx)
%
%  function:  dispF(F,idx);
%
%  Display sequence of phones and linguistic factors in structure `F`.
%
%  Inputs:   F   = structure containing a phone sequence and the 
%                  corresponding linguistic factors as generated by
%                  functions `load_training_data` and `load_phonol_repr`
%            ind = the indexes to be displayed on the terminal
%
%  Synopsis:
%            dispF(F,1:10)    displays info of phones 1 - 10 
%            dispF(F)         displays info of all phones
%

if nargin < 2,
  help dispF
  return
end

if nargin < 2,
  idx = 1:size(F.phone_id,1);
end

disp(' ')
disp(['Laut   Laut-  Silben- Position  Akzent-  Silben-  ' ...
      'Phrasen- Phrasen- Phrasen-'])
disp(['       nummer groesse in Silbe  staerke  nummer   ' ...
      'groesse  typ      grenze'])
disp(' ')

for i = 1:size(idx,2),
  fprintf(['%s     %d      %d       %s         %d       ' ...
           '%3d       %2d       %s        %s\n'],...
          F.phone_id(idx(i),:),...
          F.phone_number(idx(i)),...
          F.syllable_size(idx(i)),...
          deblank(F.phone_position(idx(i))),...
          F.accent(idx(i)),...
          F.syllable_number(idx(i)),...
          F.phrase_size(idx(i)),...
          deblank(F.phrase_type(idx(i),:)),...
          F.phrase_boundary(idx(i)));
end
