function syn = diphone_synthesis( elem_nam, dur, ffreq, SamplFreq, POrd, WinSize, WinShift)
%DIPHONE_SYNTHESIS Verkettungssynthese

if (~exist('SamplFreq', 'var')), SamplFreq = 8000; end  % Hz
if (~exist('POrd', 'var')), POrd = 12; end  % Praediktorordnung
if (~exist('WinSize', 'var')), WinSize = 176; end  % Laenge des Analysefensters
if (~exist('WinShift', 'var')), WinShift = 80; end  % Verschiebung des Analysefensters


%   Verkettungssynthese
%------------------------------------
%
zs = zeros(1,POrd);           % Zustandsgroessen des Synthesefilters 0 setzen
left = 0;                     % Restlaenge der letzten Pitch-Periode
syn = [];



for nseg = 1:length(dur),
  ovl = WinSize-WinShift;
  [seg,voiced] = get_corp_elem(elem_nam(nseg,:),ovl);   % Signalsegment laden 
  nframes = floor((length(seg)-ovl)/WinShift);
  fprintf(1,'%s ',deblank(elem_nam(nseg,:)))

  
  for nf = 1:nframes,                       % Dauer und Grundfrequenz mittels
    ns = (nf-1)*WinShift+1;                 % LPC-Analyse-Synthese veraendern
    s = seg(ns:ns+WinSize-1);
    [G,mx,P,A] = LPC_analysis(s,POrd,0,0,-1);      % (ohne Pitch-Detektion)
    if voiced == 1,
      P = fix(SamplFreq/ffreq(nseg));
    end
    synlen = fix(dur(nseg)/1000/nframes*SamplFreq);
    [xsyn,left,zs] = LPC_synthesis(G,P,left,A,synlen,zs);
    syn = [syn xsyn];
  end
end
fprintf('\n\n');


