function [derivation_values, declination_values]  = compute_declination_and_derivation(F, f0)
%% Annaeherung der Deklinationsgeraden und Berechung der Abweichung der einzelnen Laute (!) davon
%% ------------------------------------------------------------------------
%%

if exist('.derivation.mat', 'file')
  load .derivation.mat
else
  % Berechnung der Deklinationsgeraden
  terminal_declination = [];
  progredient_declination = [];
  derivation_values = zeros(size(F.phone_number));

  syllable_ends = find(F.phone_number == F.syllable_size);
  phrase_boundaries0 = strmatch('0', F.phrase_boundary, 'exact'); % sentence boundaries
  phrase_boundaries1 = strmatch('1', F.phrase_boundary, 'exact'); % strong phrase boundaries
  phrase_boundaries = intersect(syllable_ends, union(phrase_boundaries0, phrase_boundaries1));
  phrase_boundaries = [0; phrase_boundaries]; % all phrase boundaries
  for i = 1:length(phrase_boundaries) - 1
    start_index = phrase_boundaries(i) + 1;
    end_index = phrase_boundaries(i+1);   
    % berechne Deklination aus den Silbenkernen
    relative_indexes = find(F.phone_position(start_index:end_index) == 'n');
    absolute_indexes = relative_indexes + start_index - 1;
    time_dim = 1:length(absolute_indexes);
    f0_dim = f0(absolute_indexes);
    [cf, d1] = linear_polynomial_fit(time_dim,f0_dim);
    if isempty(cf)
      continue;
    end
    declination_values_segment = cf(time_dim);
    derivation_values(absolute_indexes) = f0(absolute_indexes) - declination_values_segment;
    declination_values(start_index:end_index) = d1;
  end
  save .derivation.mat derivation_values declination_values
end
