function [s,do,zo] = LPC_synthesis(G,P,di,A,ns,zi)
%
%  function:  [s,do,zo] = LPC_synthesis(G,P,di,A,ns,zi)
%
%  pitch-excited LPC synthesis of `ns` sampled data points
%  of a speech signal 
% 
%  inputs:   G    gain factor (RMS of prediction error)
%            P    pitch period (number of samples)  
%            di   delay of 1st pitch pulse (from previous frame)
%            A    synthesis filter coeffs (A(1) = 1)
%            ns   number of signal samples to be synthesized
%            zi   filter state variables (initial)
%
%  outputs:  s    synthesized speech signal 
%            zo   filter state variables (final)
%            do   delay of 1st pitch pulse (for next frame)
%

if di < ns 
  P = round(P);   
  if P > 0                               % setup voiced excitation signal
    u = zeros(1,ns); 
    u(1+di:P:ns) = sqrt(P)*G;
    do = rem(P-rem(ns-di,P),P);
  else                                   % setup unvoiced excitation signal
    u = (2*rand(1,ns)-1.0)*sqrt(3)*G;
    if di > 0
      u(1:di) = 0;
    end
    do = 0;
  end
else
  u = zeros(1,ns);               % delay > 'ns' data points
  do = di-ns;
end
[s,zo] = filter([1],A,u,zi);
