%   Uebung 5  Aufgabe 2:  LPC-Analyse-Synthese
% ------------------------------------------------

clear all;

StartFrame = 1;
NumbOfFrames = -1;    % -1 heisst alle Frames

%---- Analyseparameter ----

K = 12;            % Praediktorordnung
WinSize = 300;     % Laenge des Analysefensters
WinShift = 100;    % Verschiebung des Analysefensters
Pmin = 50;         % Suchbereich des Max in der AKF
Pmax = 120;        % 
vthr = 0.35;       % Schwellwert fuer den Entscheid stimmhaft/-los

%---- Syntheseparameter ----

FoModFac = 1.0;    % Veraenderungsfaktor der Tonhoehe
DurModFac = 1.0;   % Veraenderungsfaktor der Signaldauer


%  Signal "sig" laden
%--------------------------------------------------------------------------

disp('Signal laden ...');
[sig,SamplFreq] = audioread('ueb5_sig.wav');


%  Abschnittweise LPC-Analyse des Signals
%--------------------------------------------------------------------------
%
%  (Resultate in 2-dimensionaler Matrix 'lpc_data' Speichern: 
%   Verstaerkung, Periode, Synthesefilterkoeff(1:K+1) )

disp('Signalanalyse ...');
totFrames = fix((length(sig)-WinSize)/WinShift+1);
if StartFrame > totFrames
  fprintf(['number of frames in file: ' num2str(totFrames)]);
  fprintf(['  (program aborted)\n']);
  return
end
if NumbOfFrames == -1
  NumbOfFrames = totFrames-StartFrame+1;
else
  if StartFrame+NumbOfFrames-1 > totFrames
    NumbOfFrames = totFrames-StartFrame+1;
  end
end

lpc_data = zeros(K+3,NumbOfFrames);
acf_max = zeros(1,NumbOfFrames);
for nf = 1:NumbOfFrames,
  ns = (StartFrame+nf-2)*WinShift+1;
  s(1:WinSize) = sig(ns:ns+WinSize-1);
  [G,mx,P,A] = LPC_analysis(s,K,Pmin,Pmax,vthr);
  lpc_data(1,nf) = G;         % LPC-Parameter speichern
  lpc_data(2,nf) = P;
  lpc_data(3:K+3,nf) = A(1:K+1);
  acf_max(nf) = mx;
end


%  Graphik des Signals, der AKF-Maxima und des Grundfrequenz-Verlaufs
%--------------------------------------------------------------------------

figure(1)
clf

pt0 = (StartFrame-1)*WinShift+1;                     % Signal
pts = NumbOfFrames*WinShift;
t = (pt0-1:pt0+pts-2)/SamplFreq;
tRange(1:2) = [t(1) t(pts)]; 

axes('position',[0.05 0.74 0.90 0.20])
plot(t(1:pts),sig(pt0:pt0+pts-1));
set(gca,'xlim',tRange);
str = [num2str(StartFrame) '-' num2str(StartFrame+NumbOfFrames-1)];
title(['Originalsignal  (Analyseabschnitte ' str ')'])
                                                     % Maxima in AKF
t(1:NumbOfFrames+1) = (StartFrame+(1:NumbOfFrames+1)-2)*WinShift/SamplFreq;
axes('position',[0.05 0.42 0.90 0.20])
stairs(t(1:NumbOfFrames+1),[acf_max(1:NumbOfFrames) acf_max(NumbOfFrames)]);
hold on
plot([t(1) t(NumbOfFrames+1)],[vthr vthr],':');      % Entscheidungsschwelle
hold off
set(gca,'xlim',tRange);
set(gca,'ylim',[0 1]);
title(['Maximum der AKF im Bereich ' num2str(Pmin) '...' num2str(Pmax)])

pp = zeros(1,NumbOfFrames);                          % Grundfrequenz
for nf = 1:NumbOfFrames, 
  if lpc_data(2,nf) > 0
    pp(1,nf) = SamplFreq/lpc_data(2,nf);
  else 
    pp(1,nf) = 0;
  end
end
axes('position',[0.05 0.05 0.90 0.25])
stairs(t(1:NumbOfFrames+1),[pp(1:NumbOfFrames) pp(NumbOfFrames)]);
hold on
plot(tRange,[1 1]*SamplFreq/Pmin,':g')
plot(tRange,[1 1]*SamplFreq/Pmax,':r')
hold off
set(gca,'xlim',tRange);
set(gca,'ylim',[0 1.05*SamplFreq/Pmin]);
title(['Grundfrequenz in Hz  (0 = stimmlos)'])

pause(1)


%  Abschnittweise LPC-Synthese
%--------------------------------------------------------------------------
%
disp('LPC-Synthese des Signals ...');

synlen = round(WinShift*DurModFac);  

[K nFr] = size(lpc_data);
K = K-3;
zs = zeros(K,1);                  % Zustandsgroessen des Filters 0 setzen
syn = zeros(nFr*synlen,1);        % Laenge des rekonstruierten Signals
left = 0;                         % Ueberbleibsel der letzten Periode    
for nf = 1:nFr,
  G = lpc_data(1,nf);                  % ein Satz LPC-Parameter verarbeiten
  P = round(lpc_data(2,nf)/FoModFac);
  A(1:K+1) = lpc_data(3:K+3,nf);
  ns = (nf-1)*synlen+1;
  [syn(ns:ns+synlen-1),left,zs] = LPC_synthesis(G,P,left,A,synlen,zs);
end

maxs = 0.999;                     % Signalamplitude muss kleiner als 1 sein
over = abs(syn) > maxs;
syn(over) = sign(syn(over))*maxs;
				  


%  Graphik des originalen und des rekonstruierten Signals 
%--------------------------------------------------------------------------
%
figure(2)
pos = get(gcf,'position');
if pos(4) == 420
  add = 200;
  pos(1) = pos(1)-add;
  pos(3) = pos(3)+2*add;
  pos(4) = pos(4)-150;
  set(gcf,'position',pos)
end
clf

pt0 = (StartFrame-1)*WinShift+1;
lensig = nFr*WinShift;
lensyn = nFr*synlen;
lens = max(lensig,lensyn);
t = (pt0+(0:lens-1))/SamplFreq;

axes('position',[0.03 0.57 0.95 0.35]);        % Originalsignal
plot(t(1:lensig),sig(pt0+(0:lensig-1)));
set(gca,'xlim',[t(1) t(lens)]);
set(gca,'ylim',[-1 1]);
title(['Originalsignal'])

axes('position',[0.03 0.07 0.95 0.35])         % rekonstruiertes Signal
plot(t(1:lensyn),syn);
set(gca,'xlim',[t(1) t(lens)]);
set(gca,'ylim',[-1 1]);
str = 'Signal aus LPC-Synthese:  ';
str = [str num2str(DurModFac*100) '% Dauer,  '];
str = [str num2str(FoModFac*100) '% Grundfrequenz'];
title(str)


%   Audio-Ausgabe
%----------------------------
%
ch = ' ';
while lower(ch) ~= 'q',
  fprintf ('\nAbspielen:   1  Originalsignal \n')
  fprintf  (['             2  rekonstruiertes Signal \n'])
  ch = input('             q  Ende           >> ','s');
  if isempty(ch)
    ch = ' ';
  end
  if ch == '1'
    sound(sig(pt0+(0:lensig-1)),SamplFreq);
  end
  if ch == '2'
    sound(syn,SamplFreq);
  end
end
