%   Uebung 5  Aufgabe 1:  LPC-Analyse 
%----------------------------------------

clear all;

StartFrame = 1;
NumbOfFrames = 80;

K = 12;            % Praediktorordnung
WinSize = 300;     % Laenge des Analysefensters
WinShift = 100;    % Verschiebung des Analysefensters
Pmin = 50;         % Suchbereich des Max in der AKF:  min Periodenlaenge
Pmax = 120;        %                                  max Periodenlaenge
vthr = 0.35;       % Schwellwert fuer den Entscheid stimmhaft/-los


%  Signal "sig" laden
%--------------------------------------------------------------------------
%
disp('Signal laden ...');
[sig,SamplFreq] = audioread('ueb5_sig.wav');


%  Abschnittweise LPC-Analyse des Signals
%--------------------------------------------------------------------------
%
%  (Resultate in 2-dimensionaler Matrix 'lpc_data' Speichern: 
%   Verstaerkung, Periode, Filterkoeffizienten(1:K+1) )
%
disp('Signalanalyse ...');
totFrames = fix((length(sig)-WinSize)/WinShift+1);
if StartFrame > totFrames
  fprintf(['number of frames in file: ' num2str(totFrames)]);
  fprintf(['  (program aborted)\n']);
  return
end
if StartFrame+NumbOfFrames-1 > totFrames
  NumbOfFrames = totFrames-StartFrame+1;
else 
  NumbOfFrames = NumbOfFrames;
end
lpc_data = zeros(K+3,NumbOfFrames);
acf_max = zeros(1,NumbOfFrames);
for nf = 1:NumbOfFrames,
  ns = (StartFrame+nf-2)*WinShift+1;
  s(1:WinSize) = sig(ns:ns+WinSize-1);
  [G,mx,P,A] = LPC_analysis(s,K,Pmin,Pmax,vthr);
  lpc_data(1,nf) = G; 			% LPC-Parameter speichern
  lpc_data(2,nf) = P;
  lpc_data(3:K+3,nf) = A(1:K+1);
  acf_max(nf) = mx;
end



%  Graphik des Signals, der AKF-Maxima und des Grundfrequenz-Verlaufs
%--------------------------------------------------------------------------

figure(1)
clf
pt0 = (StartFrame-1)*WinShift+1;                     % Signal
pts = NumbOfFrames*WinShift;
t = (pt0-1:pt0+pts-2)/SamplFreq;
tRange = [t(1) t(pts)]; 
axes('position',[0.05 0.74 0.90 0.20])
plot(t(1:pts),sig(pt0:pt0+pts-1));
set(gca,'xlim',tRange);
str = [num2str(StartFrame) '-' num2str(StartFrame+NumbOfFrames-1)];
title(['Originalsignal  (Analyseabschnitte ' str ')'])
                                                     % Maxima in AKF
t(1:NumbOfFrames+1) = (StartFrame+(1:NumbOfFrames+1)-2)*WinShift/SamplFreq;
axes('position',[0.05 0.42 0.90 0.20])
stairs(t(1:NumbOfFrames+1),[acf_max(1:NumbOfFrames) acf_max(NumbOfFrames)]);
hold on
plot([t(1) t(NumbOfFrames+1)],[vthr vthr],':');      % Entscheidungsschwelle
hold off
set(gca,'xlim',tRange);
set(gca,'ylim',[0 1]);
text(tRange(2),vthr,'vthr  ','color','b', ...
	 'HorizontalAlignment','right','VerticalAlignment','top');
title(['Hoehe des Maximums der normierten AKF im Bereich ' ... 
            num2str(Pmin) '...' num2str(Pmax) ' T_s'])

pp = zeros(1,NumbOfFrames);                          % Grundfrequenz
for nf = 1:NumbOfFrames, 
  if lpc_data(2,nf) > 0
    pp(1,nf) = SamplFreq/lpc_data(2,nf);
  else 
    pp(1,nf) = 0;
  end
end
axes('position',[0.05 0.05 0.90 0.26])
stairs(t(1:NumbOfFrames+1),[pp(1:NumbOfFrames) pp(NumbOfFrames)]);
hold on
plot(tRange,[1 1]*SamplFreq/Pmin,':g')
plot(tRange,[1 1]*SamplFreq/Pmax,':r')
hold off
set(gca,'xlim',tRange);
set(gca,'ylim',[0 1.05*SamplFreq/Pmin]);
text(tRange(2),SamplFreq/Pmin,'f_s/Pmin  ','color','g', ...
	 'HorizontalAlignment','right','VerticalAlignment','top');
text(tRange(2),SamplFreq/Pmax,'f_s/Pmax  ','color','r', ...
	 'HorizontalAlignment','right','VerticalAlignment','top');
title(['Grundfrequenz in Hz  (0 = stimmlos)'])
