echo on

%  Uebung 4  Aufgabe 3
%---------------------------------------------------------------------------


clear all

%  Lautsegmente laden
%--------------------------------------------------------------------------

[sig_a,fs] = audioread('seg_vowel_a.wav');
[sig_s,fs] = audioread('seg_consonant_s.wav');


%  mit Fensterfunktion multiplizieren
%--------------------------------------------------------------------------

win = 1.588*hamming(length(sig_a));  % leistungskompensiertes Hamming-Fenster
sig_aw = sig_a.*win;
sig_sw = sig_s.*win;

 
%  Signal, Praediktionsfehler und deren Leistungsdichtespektren darstellen
%--------------------------------------------------------------------------

figure(1)
clf
pos = get(gcf,'position');     % Graphik-Fenster vergroessern
if pos(4) == 420
  yadd = 350;
  pos(2) = pos(2)-yadd;
  pos(4) = pos(4)+yadd;
  set(gcf,'position',pos)
end

lpc_demo(sig_aw,12,512,fs);
subplot(411);
yl = get(gca,'ylim');
text(0,yl(2)+0.35*(yl(2)-yl(1)),'LPC-Analyse des Lautes [a]','FontSize',15);
pause;

figure(2)
clf
pos = get(gcf,'position');     % Graphik-Fenster vergroessern
if pos(4) == 420
  yadd = 350;
  pos(2) = pos(2)-yadd;
  pos(4) = pos(4)+yadd;
  set(gcf,'position',pos)
end

lpc_demo(sig_sw,12,512,fs);
subplot(411);
yl = get(gca,'ylim');
text(0,yl(2)+0.35*(yl(2)-yl(1)),'LPC-Analyse des Lautes [s]','FontSize',15);

%  Der Praediktionsfehler ist bei Laut [a] jeweils am Anfang des glottalen 
%  Pulses am groessten. Sowohl im Spektrum des Signals des Lautes [a] 
%  als auch im Spektrum des Fehlersignals erkennt man die harmonische 
%  Struktur, weil beide Signale periodisch sind.
%  Beim Laut [s] ist der Praediktionsfehler wie das Signal selbst auch 
%  rauschartig. 
%  Die Enveloppe des Leistungsdichtespektrums des Fehlersignals ist bei 
%  beiden Lauten ungefaehr eben.

echo off
