echo on

%  Uebung 4   Aufgabe 2
%----------------------------------------------------------------------------

clear all
figure(1)
clf


%  Lautsegmente laden
%--------------------------------------------------------------------------

[sig_a,fs] = audioread('seg_vowel_a.wav');
[sig_s,fs] = audioread('seg_consonant_s.wav');


%  mit Fensterfunktion multiplizierte Segmente darstellen
%--------------------------------------------------------------------------

win = 1.588*hamming(length(sig_a));  % leistungskompensiertes Hamming-Fenster
sig_aw = sig_a.*win;
sig_sw = sig_s.*win;

subplot(211);
plot(sig_aw);
set(gca,'xlim',[1 length(sig_aw)]);
set(gca,'ylim',[-1.2 +1.2]);
title(' Lautsegment [a] mit Hamming-Fenster multipliziert ');
subplot(212);
plot(sig_sw);
set(gca,'xlim',[1 length(sig_s)]);
set(gca,'ylim',[-0.2 +0.2]);
title(' Lautsegment [s] mit Hamming-Fenster multipliziert ');
pause;


%  Leistungsdichtespektrum des Lautes [a] und Uebertragungsfunktion
%  des linearen Praediktors mit verschiedenen Ordnungen
%-----------------------------------------------------------------------------

orders1 = [4,6,8,10];
orders2 = [12,14,16,18];

plot_lpc_approx(sig_aw,orders1,512,fs);
subplot(411);                    % Titel ueber oberstem Subplot
str = 'Leistungsdichte- und LPC-Spektren des Lautes [a]';
y = get(gca,'ylim');
text(2000,1.3*y(2)-0.3*y(1),str,'horiz','center','FontSize',14);
pause;

plot_lpc_approx(sig_aw,orders2,512,fs);
subplot(411);                    % Titel ueber oberstem Subplot
y = get(gca,'ylim');
text(2000,1.3*y(2)-0.3*y(1),str,'horiz','center','FontSize',14);
pause;


%  Leistungsdichtespektrum des Lautes [s] und Uebertragungsfunktion
%  des linearen Praediktors mit verschiedenen Ordnungen
%-----------------------------------------------------------------------------

plot_lpc_approx(sig_sw,orders1,2048,fs);
subplot(411);                    % Titel ueber oberstem Subplot
str = 'Leistungsdichte- und LPC-Spektren des Lautes [s]';
y = get(gca,'ylim');
text(fs/4,1.3*y(2)-0.3*y(1),str,'horiz','center','FontSize',14);
pause;

plot_lpc_approx(sig_sw,orders2,2048,fs);
subplot(411);                    % Titel ueber oberstem Subplot
y = get(gca,'ylim');
text(fs/4,1.3*y(2)-0.3*y(1),str,'horiz','center','FontSize',14);
pause;
close(2);

%  Das LPC-Spektrum zeichnet den Verlauf des Leistungsdichtespektrums 
%  mit steigender Praediktorordnung immer genauer nach. Bereits mit 
%  einer Ordnung von 12 werden die Formanten gut approximiert. Die 
%  Approximation des LPC-Spektrums ist vor allem bei den Maxima gut.

echo off
