echo on

%  Uebung 4   Aufgabe 1
%---------------------------------------------------------------------------

clear all
figure(1)
clf


%  Lautsegmente laden und darstellen
%--------------------------------------------------------------------------

[sig_a,fs] = audioread('seg_vowel_a.wav');
[sig_s,fs] = audioread('seg_consonant_s.wav');

subplot(211);
plot(sig_a);
set(gca,'xlim',[1 length(sig_a)]);
set(gca,'ylim',[-1 +1]);
title(' Segment aus Laut [a] ');

subplot(212);
plot(sig_s);
set(gca,'xlim',[1 length(sig_s)]);
set(gca,'ylim',[-0.2 +0.2]);
title(' Segment aus Laut [s] ');
pause;


%  mit Fensterfunktion multiplizierte Segmente darstellen
%--------------------------------------------------------------------------

win = hamming(length(sig_a));   % Fensterfunktion
sig_aw = sig_a.*win;
sig_sw = sig_s.*win;

subplot(211);
plot(sig_aw);
set(gca,'xlim',[1 length(sig_aw)]);
set(gca,'ylim',[-1 +1]);
title(' Lautsegment [a] mit Hamming-Fenster multipliziert ');

subplot(212);
plot(sig_sw);
set(gca,'xlim',[1 length(sig_sw)]);
set(gca,'ylim',[-0.2 +0.2]);
title(' Lautsegment [s] mit Hamming-Fenster multipliziert ');
pause;


% LPC-Analyse der Signale (Ordnung 12)

[A_a,E_a] = lpc(sig_aw,12);
[A_s,E_s] = lpc(sig_sw,12);


%  Uebertragungsfunktion von A(z) fuer Laut [a]
%--------------------------------------------------------------------------

B = 1;
[freq_resp_A_a,W1] = freqz(A_a,B,512);
F1 = W1/(2*pi);
clf;
subplot(211);
plot(F1,20*log10(abs(freq_resp_A_a)));   % Betragsspektrum in dB
ylabel('Betrag in dB');
title(' Inverses Filter A(z) des Lautes [a]');
grid;


%  Uebertragungsfunktion des Synthesefilters H(z) fuer Laut [a]
%--------------------------------------------------------------------------

[freq_resp_H_a,W2] = freqz(B,A_a,512);
F2 = W2/(2*pi);
subplot(212);
plot(F2,20*log10(abs(freq_resp_H_a)));   % Betragsspektrum in dB
grid;
xlabel('Normierte Frequenz');
ylabel('Betrag in dB');
title(' Synthesefilter H(z) des Lautes [a]');

%  Die Nullstellen von A(z) entsprechen den Polen der 
%  Uebertragungsfunktion des Synthesefilters H(z).
%  A(z) und H(z) sind symmetrisch zur 0-dB-Achse.
pause;


%  Uebertragungsfunktion von A(z) fuer Laut [s]
%--------------------------------------------------------------------------

subplot(211);
[freq_resp_A_s,W1] = freqz(A_s,B,512);
F1 = W1/(2*pi);
plot(F1,20*log10(abs(freq_resp_A_s)));   % Betragsspektrum in dB
grid;
ylabel('Betrag in dB');
title(' Inverses Filter A(z) des Lautes [s]');

%  Uebertragungsfunktion des Synthesefilters H(z) fuer Laut [s]
%--------------------------------------------------------------------------

[freq_resp_H_s,W2] = freqz(B,A_s,512);
F2 = W2/(2*pi);
subplot(212);
plot(F2,20*log10(abs(freq_resp_H_s)));   % Betragsspektrum in dB
grid;
xlabel('Normierte Frequenz');
ylabel('Betrag in dB');
title(' Synthesefilter H(z) des Lautes [s]');
pause;


%  Uebertragungsfunktionen H(z) fuer beide Laute darstellen
%--------------------------------------------------------------------------

subplot(211);
plot(F1,20*log10(abs(freq_resp_H_a)));
grid;
ylabel('Amplitude in dB');
title('  Synthesefilter H(z) des Lautes [a]');

subplot(212);
plot(F2,20*log10(abs(freq_resp_H_s)));
grid;
xlabel('Normierte Frequenz');
ylabel('Amplitude in dB');
title('  Synthesefilter H(z) des Lautes [s]');
pause;


%  Pole und Nullstellen fuer beide Laute darstellen
%--------------------------------------------------------------------------

figure(2);
clf
zplane(1,A_a);
title(' Pole von H(z) fuer Laut [a]');
pause;

figure(3);
clf
zplane(1,A_s);
title(' Pole von H(z) fuer Laut [s]');

%  Bei den Polen weist die Uebertragungsfunktion des Synthesefilters
%  H(z) ein lokales Maximum auf. Je naeher ein Pol beim
%  Einheitskreis liegt, desto ausgepraegter ist das betreffende
%  lokale Maximum.

echo off
