function  plot_lpc_approx(sig,orders,nfft,fs);
%
%  function  plot_lpc_approx(sig,orders,nfft,fs);
%  
%  Plot the power density spectrum of signal `sig` and the transfer 
%  function of the corresponding LPC synthesis filter (the so-called
%  LPC spectrum) for different filter orders specified in vector `orders`. 
%  `nfft` denotes the resolution of the Fourier transform and `fs` is
%  the sampling frequency. 

figure(2)    
pos = get(gcf,'position');         % increase window height 
if pos(4) == 420
  yadd = 350;
  pos(2) = pos(2)-yadd;
  pos(4) = pos(4)+yadd;
  set(gcf,'position',pos)
end

numorders = length(orders);
                                              % power density spectrum in dB
power_spec = 10*log10(abs(fft(sig,nfft)).^2/length(sig));
f = (0:nfft-1)/nfft*fs;                       % frequency resolution
ylims = ceil(max(power_spec)/10)*10+[-50 0];  % dB range on plot 

for iord = 1:numorders,
  subplot(numorders,1,iord);
  plot(f(1:nfft/2+1),power_spec(1:nfft/2+1));  % plot power density spectrum
  set(gca,'ylim',ylims)
  hold on;
                                   
  [A,E] = lpc(sig,orders(iord));   % compute predictor coeffs
  B = 1;        
  [H,W] = freqz(B,A,nfft*2);       % evaluate and plot transfer function
  fp = fs*W/(2*pi);  
  G = sqrt(E);
  plot(fp,20*log10(G*abs(H)));
  hold off;
  ylabel('Amplitude in dB');
  title(['Praediktor Ordnung: ' int2str(orders(iord))]);
end
subplot(numorders,1,numorders);
xlabel('Frequenz in Hz');

