function  lpc_demo(sig,ord,nfft,fs);
%
%  function:  lpc_demo(sig,ord,nfft,fs);
%
%  Compute for signal segment 'sig' the predictor of order 'ord' and 
%  make four subplots showing:
%     1. the signal segment 'seg'
%     2. the prediction error signal
%     3. the power density spectrum of the signal segment 'seg' and the
%        transfer function of the predictor 
%     4. the power density spectrum of the prediction error signal
%  The sampling frequency is 'fs' and the FFT resolution is 'nfft'.

                                 % power density spectrum of signal in dB
pd_spec_sig = 10*log10(abs(fft(sig,nfft)).^2/length(sig));   
f = (0:nfft-1)/nfft*fs;
[A,E] = lpc(sig,ord);                      % evaluate predictor
B = 1;
[H,W] = freqz(B,A,nfft/2);                 % predictor transfer function
err_sig = filter(A,B,sig);                 % prediction error signal
                                 % power density spectrum of error in dB
pd_spec_err = 10*log10(abs(fft(err_sig,nfft)).^2/length(sig));

subplot(411);                    % plot signal
t = (0:length(sig)-1)/fs;
plot(t,sig);
set(gca,'xlim',[0 length(sig)/fs])
ylims = max(abs(sig))*1.1*[-1 1];
set(gca,'ylim',ylims);
title('Signal');

subplot(412);                    % plot prediction error signal
plot(t,err_sig);
set(gca,'xlim',[0 length(sig)/fs])
set(gca,'ylim',ylims)
title('Praediktionsfehler');

subplot(413);                    % plot power density spectrum of signal
plot(f(1:nfft/2),pd_spec_sig(1:nfft/2));
hold on;
G = sqrt(E);                     % plot LPC spectrum
plot(f(1:nfft/2),20*log10(G*abs(H)));
hold off;
ylims = ceil(max(pd_spec_sig)/10)*10+[-50 0];
set(gca,'ylim',ylims)
ylabel('Amplitude in dB');
title(['Leistungsdichtespektrum des Signals und H(z)']);

subplot(414);                    % plot power density spectrum of error signal
plot(f(1:nfft/2),pd_spec_err(1:nfft/2));
set(gca,'ylim',ylims)
xlabel('Frequenz in Hz');
ylabel('Amplitude in dB');
title('Leistungsdichtespektrum des Fehlers');
