echo on;

%   Uebung 3  Aufgabe 3a
%--------------------------------------
% 
%   Spektrogramm 4 ueberlagerter Sinus-Sweeps

clear all

len = 2;     % Laenge der Sweep-Signale [s]
amp = 0.2;   % Ampitude Sweep-Signale
fs = 8000;   % Abtastfrequenz [Hz]

winlen = 300;    % Laenge des Analysefensters 
winshift = 80;   % Verschiebung des Analysefensters 
nfft = 512;      % DFT-Laenge 

overlap = winlen-winshift;

figure(1)
clf;

s1 = linsweep(100/fs,3700/fs,0,amp,len*fs);
s2 = linsweep(100/fs,3300/fs,0,amp,len*fs);
s3 = linsweep(1800/fs,100/fs,0,amp,len*fs);
s4 = linsweep(2000/fs,100/fs,0,amp,len*fs);
s = s1+s2+s3+s4;
ax = [0 25];
[B F T] = spectrogram(s,hamming(winlen),overlap,nfft,fs);
imagesc(T,F,20*log10(abs(B)),ax);
axis xy;
colormap(jet);
colorbar;

echo off
