function showdft(x,X,howx,howX);
%
%  function showdft(x,X,howx,howX)
%
%  Display the complex time series `x` and its DFT `X` as four subplots. 
%  `howx` and `howX` control the representation of `x` and `X` either as 
%  real and imaginary part ('ri') or as amplitude and phase ('ap'). 
%
epsilon = 0.000001;
N = length(x);
xlim = [0 N-1];
nn = (0:N-1);

%---- display time series x ----
%
figure(1)
if howx == 'ri'
  subplot(221);
  stem(nn,real(x));
  set(gca,'xlim',xlim)
  title('real part of x(n)');
  subplot(223);
  stem(nn,imag(x));
  set(gca,'xlim',xlim)
  title('imaginary part of x(n)');
else
  subplot(221);
  stem(nn,abs(x));
  set(gca,'xlim',xlim)
  title('amplitude of x(n)');
  subplot(223);
  x = round(x./epsilon).*epsilon;  % floor values for angle calculation
  stem(nn,angle(x));
  set(gca,'xlim',xlim)
  set(gca,'ylim',[-pi +pi])
  set(gca,'ytick',[-pi -pi/2 0 +pi/2 +pi])
  set(gca,'yticklabel',['  -pi';'-pi/2';'    0';'+pi/2';'  +pi'])
  title('phase of x(n)');
end

%---- display DFT X ----
%
if howX == 'ri'
  subplot(222);
  stem(nn,real(X));
  set(gca,'xlim',xlim)
  title('real part of X(k)');
  subplot(224);
  stem(nn,imag(X));
  set(gca,'xlim',xlim)
  if max(abs(imag(X))) < 10^(-10)
    set(gca,'ylim',[-1 +1]);
  end
  title('imaginary part of X(k)');
else
  subplot(222);
  stem(nn,abs(X));
  set(gca,'xlim',xlim)
  title('amplitude of X(k)');
  subplot(224);
  X = round(X./epsilon).*epsilon;  % floor values for angle calculation
  stem(nn,angle(X));
  set(gca,'xlim',xlim)
  set(gca,'ylim',[-pi +pi])
  set(gca,'ytick',[-pi -pi/2 0 +pi/2 +pi])
  set(gca,'yticklabel',['  -pi';'-pi/2';'    0';'+pi/2';'  +pi'])
  set(gca,'ytick',[-pi -pi/2 0 +pi/2 +pi])
  set(gca,'yticklabel',['  -pi';'-pi/2';'    0';'+pi/2';'  +pi'])
  title('phase of X(k)');
end
