function s = linsweep(f0,f1,ph0,a,len) 
%
%  function:  s = linsweep(f0,f1,ph0,a,len)
%
%          Generates 'len' samples of a linearly sweeped sine wave with 
%          amplitude 'a', and normalized start and end frequencies 'f0' 
%          and 'f1', resp. The start phase is 'ph0' (in rad). 

if (f0 < 0) | (f0 > 0.5)
  error('normalized start frequency out of range 0.0 to 0.5');
end
if (f1 < 0) | (f1 > 0.5)
  error('normalized end frequency out of range 0.0 to 0.5');
end

t = 0:len-1;
phi = 2*pi* (f0*t + 0.5*(f1-f0).*t.*t/len) + ph0;  % phase
s = a.*sin(phi);   
