%   Uebung 2  Aufgabe 2:  lin/log Quantisierung
% ----------------------------------------------
%
clear all;

TestMode = 0;   % 0 = Normalbetrieb mit Sprachsignal
                % 1 = Testbetrieb mit Rampensignal

NBcode = input('Anzahl Bits pro Signalabtastwert  (1..8)  >> ');
if isempty(NBcode) 
  error('Code-Laenge nicht spezifiziert!')
end
if NBcode < 1 | NBcode > 8
  error('Nur Code-Laengen von 1 bis 8 Bits erlaubt!')
end


%   Signal von File laden -> Variable `sig16` 
%--------------------------------------------
%   Merke:  Variable `sig16` ist vom Matlab-Datentyp int16 und hat 
%           den Wertebereich: -32768 ... 32767. 
%           Da mit diesem Datentyp nur beschraenkt gerechnet werden
%           kann, wird das Signal in den Datentyp "double" konvertiert

if TestMode == 0 
  ainfo = audioinfo('ueb2_2_sig.wav');
  NB = ainfo.BitsPerSample;
  [sig16,SamplFreq] = audioread('ueb2_2_sig.wav','native');
  sig = double(sig16);   
else                               % zum Testen der Quantisierung: 
  NB = 16;                         % generieren des 16-Bit-Rampensignals
  SamplFreq = 8000;                % ueber den ganzen Wertebereich
  sig = (-2^(NB-1):2^(NB-1)-1);    % -2^(NB-1) ... +2^(NB-1)-1
end  


%   lineare N-Bit-Quantisierung:
%-------------------------------

%   Codierung:
%-------------
scal = 2^(NBcode-NB);             % Skalierungsfaktor 
codlin = floor(scal*min(abs(sig),2^(NB-1)-1)) + 2^(NBcode-1)*(sig<0);
                                  % "min" noetig fuer  sig = -2^(NB-1)
%   Decodierung:
%---------------
pol = 1-2*(codlin >= 2^(NBcode-1));                % Polaritaet
off = (codlin >= 2^(NBcode-1)) * 2^(NBcode-1);     % Offset fuer neg Werte
sigqlin = pol.*(codlin-off+0.5)/scal;            

if code_test(codlin,'codlin',NBcode) == 0  % Test ob Code ganzzahlig
  return
end
errlin = sig - sigqlin;
SNRlin = 10*log10(sum(sig.^2.)/sum(errlin.^2));
minlin = min(codlin);
maxlin = max(codlin)-1;
disp(' ')
disp(['SNR bei linearer ' num2str(NBcode) '-Bit-Quantisierung:  ' ...
       num2str(SNRlin) ' dB']);



%   logarithmische N-Bit-Quantisierung
%-------------------------------------

ScLog = 0.0091;  % Skalierungsfaktor des Eingangssignals 
                 % fuer max SNR bei 8-Bit-Quantisierung optimiert !!

%   Codierung:
%-------------
scal = 2^(NBcode-1)/log(2^(NB-1)*ScLog);
codlog = floor(scal*log(max(min(abs(sig),2^(NB-1)-1)*ScLog,1))) ...
                    + 2^(NBcode-1)*(sig<0);  
                                  % "min" noetig fuer  sig = -2^(NB-1)
%   Decodierung:
%---------------
pol = 1-2*(codlog >= 2^(NBcode-1));                % Polaritaet
off = (codlog >= 2^(NBcode-1)) * 2^(NBcode-1);     % Offset fuer neg Werte
sigqlog = pol.*(exp((codlog-off+0.5)/scal))/ScLog;

if code_test(codlog,'codlog',NBcode) == 0  % Test ob Code ganzzahlig
  return
end
errlog = sig - sigqlog;
SNRlog = 10*log10(sum(sig.^2.)/sum(errlog.^2));
minlog = min(codlog);
maxlog = max(codlog)-1;
disp(' ')
disp(['SNR bei logarithmischer ' num2str(NBcode) '-Bit-Quantisierung:  ' ...
       num2str(SNRlog) ' dB']);



%   graphische Darstellung 
%-------------------------

if TestMode == 1
                       % Graphik der Quantisierungs-Charakteristiken
  plot_quant_charact(sig,sigqlin,NB,codlin,NBcode,'lin',3)
  plot_quant_charact(sig,sigqlog,NB,codlog,NBcode,'log',4)
end

                       % Graphik der Signale 
if TestMode == 0
  Pt = 1600;  % Anzahl Abtastwerte fuer Graphik
else
  Pt = length(sig);
end

if sum(get(0,'children') == 2) == 0   % figure 2 not yet existing
  figure(2)
  set(gcf,'Units','normal');
  set(gcf,'position',[0.45 0.07 0.50 0.85]);
else
  figure(2)
end      
clf
Pt = min(Pt,length(sig));
t = (0:Pt-1)/SamplFreq;
hy = 0.13;
dy = 0.20;

axes('position',[0.1 0.03+4*dy 0.8 hy])
plot(t(1:Pt),sig(1:Pt),'linewidth',0.2);
title('Originalsignal')

axes('position',[0.1 0.03+3*dy 0.8 hy])
plot(t(1:Pt),sigqlin(1:Pt),'linewidth',0.2);
title(['Signal mit linearer ' num2str(NBcode) '-Bit-Quantisierung'])

axes('position',[0.1 0.03+2*dy 0.8 hy])
plot(t(1:Pt),errlin(1:Pt),'linewidth',0.2);
title(['Fehlersignal aus linearer ' num2str(NBcode) '-Bit-Quantisierung'])

axes('position',[0.1 0.03+1*dy 0.8 hy])
plot(t(1:Pt),sigqlog(1:Pt),'linewidth',0.2);
title(['Signal mit logarithmischer ' num2str(NBcode) '-Bit-Quantisierung'])

axes('position',[0.1 0.03+0*dy 0.8 hy])
plot(t(1:Pt),errlog(1:Pt),'linewidth',0.2);
title(['Fehlersignal aus logarithm ' num2str(NBcode) '-Bit-Quantisierung'])



%   Audio-Ausgabe
%----------------------------

if TestMode == 0
  ch = ' ';
  while ch ~= 'q',
    fprintf ('\nAbspielen:   1  Originalsignal\n')
    fprintf  (['             2  lin ' num2str(NBcode) '-Bit-quant Signal \n'])
    fprintf  (['             3  lin Quantisierungsfehler \n'])
    fprintf  (['             4  log ' num2str(NBcode) '-Bit-quant Signal \n'])
    fprintf  (['             5  log Quantisierungsfehler \n'])
    ch = input('             q  Ende           >> ','s');
    if isempty(ch)
      ch = ' ';
    end
    if ch == '1'
      sound(sig/2^(NB-1),SamplFreq);
    end
    if ch == '2'
      sound(sigqlin/2^(NB-1),SamplFreq);
    end
    if ch == '3'
      sound(errlin/2^(NB-1),SamplFreq);
    end
    if ch == '4'
      sound(sigqlog/2^(NB-1),SamplFreq);
    end
    if ch == '5'
      sound(errlog/2^(NB-1),SamplFreq);
    end
  end
end
