%   Uebung 2  Aufgabe 1:  aus Sinuswellen zusammengesetzte Signale
%-------------------------------------------------------------------
%
clear all;
echo on

%   Teilaufgabe a)
%-------------------- 
%
%   Grundwelle:
%
StartFreq = 200;   % Hz  
EndFreq   = 500;   % Hz
Dauer     = 3.0;   % sec
Amplitude = 0.1; 

%   Oberwellen:
%
Anzahl     = 1+7;
AmplFaktor = 0.7;

%   weitere Angaben:
%
SamplFreq = 8000; % Abtastfrequenz in Hz
Graphik   = 'T';  % 'T' -> graphische Darstellung des Signalanfangs
Pt        = 400;  % Anzahl Abtastwerte fuer graphische Darstellung

%  Generieren der Signale:
%
len = Dauer*SamplFreq;
f0  = (1:Anzahl)*StartFreq/SamplFreq;
f1  = (1:Anzahl)*EndFreq/SamplFreq;
rand('seed',0);
ph0 = 2*pi*rand(1,Anzahl);
a   = Amplitude*AmplFaktor.^(0:Anzahl-1);

x1 = frequencies2sig(f0,f1,ph0,a,len);



%   Teilaufgabe b)   (wie a), jedoch ohne Grundwelle)
%--------------------   
%
x2 = frequencies2sig(f0(2:Anzahl),f1(2:Anzahl),ph0(2:Anzahl),a(2:Anzahl),len);



%   Teilaufgabe c)
%--------------------   
%
NumSin     = 10;     % zu superponierende Sinuskomponenten
Amplitude  = 0.1/sqrt(NumSin); 
AmplFaktor = 1;

%  Generieren des Signals:
%
f0  = 0.01+0.45*rand(1,NumSin);
f1  = 0.01+0.45*rand(1,NumSin);
ph0 = 2*pi*rand(1,NumSin);
a   = Amplitude*AmplFaktor.^(0:NumSin-1);

x3 = frequencies2sig(f0,f1,ph0,a,len);

echo off


%  graphische Darstellung der Signale
%--------------------------------------------
%
t = (0:Pt-1)/SamplFreq;
figure(1)
clf
axes('position',[0.1 0.73 0.8 0.2])
plot(t(1:Pt),x1(1:Pt),'linewidth',0.2);
set(gca,'ylim',[-0.25 0.25])
title(['a)   Harmonisches Signal mit Grundwelle ' num2str(StartFreq) ' Hz und ' num2str(Anzahl-1) ' Oberwellen'])
axes('position',[0.1 0.39 0.8 0.2])
plot(t(1:Pt),x2(1:Pt),'linewidth',0.2);
set(gca,'ylim',[-0.25 0.25])
title('b)   Harmonisches Signal ohne Grundwelle')
axes('position',[0.1 0.05 0.8 0.2])
plot(t(1:Pt),x3(1:Pt),'linewidth',0.2);
set(gca,'ylim',[-0.25 0.25])
title(['c)   Nicht-harmonisches Signal aus ' num2str(NumSin) ' superponierten Sinuswellen'])



%   Feststellungen
%-----------------------------
disp(' ');
disp('Feststellungen');
disp('--------------');
disp(' ');
disp('1. Die Tonhoehen der Signale a) und b) sind gleich. ');
disp('   Das Ohr hoert nicht die Grundwelle als Tonhoehe,');
disp('   sondern den Frequenzabstand zwischen den Harmonischen.');
disp(' ');
disp('2. Beim nicht-harmonischen Signal c) sind die einzelnen ');
disp('   Sinuskomponenten hoerbar, im Gegensatz zu a) und b).');
disp('   Dies gilt nur, falls die Anzahl der Komponenten nicht');
disp('   zu gross ist. Fuer sehr viele Komponenten (z.B. 500)');
disp('   wird c) rauschartig.');
disp(' ');



%   Audio-Ausgabe
%----------------------------
ch = ' ';
while ch ~= 'q',
  ch = input('Signal abspielen oder Ende? [a|b|c|q]  ','s');
  if ch == 'a'
    sound(x1,SamplFreq);
  end
  if ch == 'b'
    sound(x2,SamplFreq);
  end
  if ch == 'c'
    sound(x3,SamplFreq);
  end
end
