function s = frequencies2sig(f0,f1,ph0,a,len);
%
%  function:  frequencies2sig(f0,f1,ph0,a,len)
%
%  Generates `len` samples of a signal consisting of superimposed 
%  sweeped sine wave components. The normalized start and end 
%  frequencies are given by the vectors `f0` and `f1`, resp. The
%  start phases of the components are specified by vector `ph0`,
%  and the amplitudes are given by the vector `a`. All these 
%  vectors must be of the same size. 

j = [length(f0) length(f1) length(ph0) length(a)];
if min(j) ~= max(j)
  error('*** amplitude, frequency, and phase vectors must have same size');
end

s = zeros(size(1:len));
for k = 1:j,
  s = s + logsweep(f0(k),f1(k),ph0(k),a(k),len);
end
