function y = sign1(x)
%
%  function:  y = sign1(x)
%
%          For each element of 'x', sign1(x) returns 1 if the element
%          is greater than or equal to zero, and -1 if it is
%          less than zero.  If at least one element of 'x' is complex 
%          sign1(x) = (sign1(real(x)) + i*sign1(imag(x))) /sqrt(2). 

if isreal(x)
  y = sign(sign(x)+0.1);
else
  y = (sign(sign(real(x))+0.1)+i*sign(sign(imag(x))+0.1))/sqrt(2);
end
