function  plot_quant_charact(sig,sigq,sbits,code,cbits,type,fig)
%
%  function  plot_quant_charact(sig,sigq,sbits,code,cbits,type,fig)
%
%  Draws the linear and the logarithmic quantization characteristics
%  in two subplots. The charateristics are evaluated from the 
%  the original data `sig` and the quantized and therefore the picture
%  is nice if there are many data points per quantization interval.
%
%  To get the two characteristics, the following commands have to 
%  be inserted at the end of ueb2_2.m:
%  plot_quant_charact(sig,NB,codlin,NBlin,'lin',3)
%  plot_quant_charact(sig,NB,codlog,NBlog,'log',3)

if sum(get(0,'children') == fig) == 0   % figure `fig` not yet existing
  figure(fig)
  pos = get(gcf,'position');
  if strcmp(type,'lin')
    x = -1;
  else
    x = 1;
  end
  set(gcf,'position',pos+[x*300 -90 0 +90]);
else
  figure(fig)
end
clf
msr = (cbits > 5);    % marker size reduction

sig = sig(:);         % make column vectors
code = code(:);  
sigq = sigq(:);  

[xpos,idx] = sort(sig);       % separate and sort positive and values
ineg = (xpos < 0); 
xpos(ineg) = [];
ypos = code(idx);
ypos(ineg) = []; 
xposq = sigq(idx);
xposq(ineg) = []; 

xneg = sig(idx);
ipos = (xneg >= 0); 
xneg(ipos) = [];
yneg = code(idx);
yneg(ipos) = []; 
xnegq = sigq(idx);
xnegq(ipos) = []; 

if strcmp(type,'lin')         % plots for linear quantization
  subplot(2,1,1)
  plot(xpos,ypos)             % positive values
  hold on
  plot(xpos,ypos,'r.','markersize',5-msr)
  plot(xposq,ypos,'kx','markersize',7-3*msr)
  plot(xposq,ypos,'ko','markersize',7-3*msr)
  hold off
  if sum(xposq<0) + sum(xposq>=2^(sbits-1)) == 0  % is decoded sig in range?
    set(gca,'xlim',[-1 2^(sbits-1)]);
    set(gca,'xtick',(0:5000:30000));
    set(gca,'xticklabel', ...
            ['  0  ';' 5000';'10000';'15000';'20000';'25000';'30000']);
  end
  if cbits > 1
    set(gca,'ylim',[0 2^(cbits-1)-1]);
    yticks = get(gca,'ytick');
  else
    set(gca,'ylim',[0 +0.1]);
    yticks = 0;
    set(gca,'ytick',yticks);
  end
  yticklabels = num2bin(yticks,cbits);        % make binay y labels
  set(gca,'yticklabel',yticklabels);
  title(['Lineare ' num2str(cbits) '-Bit-Quantisierungskennlinie  ' ... 
         '(positiver Bereich)'])

  subplot(2,1,2)
  plot(xneg,yneg)             % negative values
  hold on
  plot(xneg,yneg,'r.','markersize',5-msr)
  plot(xnegq,yneg,'kx','markersize',7-3*msr)
  plot(xnegq,yneg,'ko','markersize',7-3*msr)
  hold off
  if sum(xnegq>=0) + sum(xnegq<-2^(sbits-1)) == 0  % is decoded sig in range?
    set(gca,'xlim',[-2^(sbits-1) 0])
    set(gca,'xtick',(-30000:5000:0))
    set(gca,'xticklabel', ...
            ['-30000';'-25000';'-20000';'-15000';'-10000';' -5000';'  0   '])
  end
  if cbits > 1
    set(gca,'ylim',[2^(cbits-1) 2^(cbits)-1])
    yticks = get(gca,'ytick');
  else
    set(gca,'ylim',[0.9 1]);
    yticks = 1;
    set(gca,'ytick',yticks);
  end
  yticklabels = num2bin(yticks,cbits);
  set(gca,'yticklabel',yticklabels);
  title(['Lineare ' num2str(cbits) '-Bit-Quantisierungskennlinie  ' ... 
         '(negativer Bereich)'])
  
else                          % plots for logarithmic quantization
  subplot(2,1,1)
  semilogx(xpos,ypos)         % positive values
  hold on
  semilogx(xpos,ypos,'r.','markersize',5-msr)
  semilogx(xposq,ypos,'kx','markersize',7-3*msr)
  semilogx(xposq,ypos,'ko','markersize',7-3*msr)
  hold off
  if sum(xposq<0) + sum(xposq>=2^(sbits-1)) == 0  % is decoded sig in range?
    set(gca,'xlim',[0 2^(sbits-1)]);
  else
    if min([1; xposq])*max([2^(sbits-1); xposq]) < 0  % bipolar?
      set(gca,'xscale','linear')
    else 
      set(gca,'xlim',[min([1; xposq]) max([2^(sbits-1); xposq])])
    end
  end
  if cbits > 1 
    set(gca,'ylim',[0 2^(cbits-1)-1]);
    yticks = get(gca,'ytick');
  else
    set(gca,'ylim',[0 0.1]);
    yticks = 0;
    set(gca,'ytick',yticks);
  end
  yticklabels = num2bin(yticks,cbits);
  if ~isempty(yticklabels)
    set(gca,'yticklabel',yticklabels);
  end
  title(['Logarithmische ' num2str(cbits) '-Bit-Quantisierungskennlinie  ' ... 
         '(positiver Bereich)'])

  subplot(2,1,2)
  semilogx(xneg,yneg)         % negative values
  hold on
  semilogx(xneg,yneg,'r.','markersize',5-msr)
  semilogx(xnegq,yneg,'kx','markersize',7-3*msr)
  semilogx(xnegq,yneg,'ko','markersize',7-3*msr)
  hold off
  if sum(xnegq>=0) + sum(xnegq<-2^(sbits-1)) == 0  % is decoded sig in range?
    set(gca,'xlim',[-2^(sbits-1) 0]);
  else
    if min([-2^(sbits-1); xnegq])*max([-1; xnegq]) < 0  % bipolar?
      set(gca,'xscale','linear')
    else 
      set(gca,'xlim',[min([-2^(sbits-1); xnegq]) max([0; xnegq])])
    end
  end
  if cbits > 1
    set(gca,'ylim',[2^(cbits-1) 2^(cbits)-1]);
    yticks = get(gca,'ytick');
  else
    set(gca,'ylim',[0.9 1]);
    yticks = 1;
    set(gca,'ytick',yticks);
  end
  yticklabels = num2bin(yticks,cbits);
  set(gca,'yticklabel',yticklabels);
  title(['Logarithmische ' num2str(cbits) '-Bit-Quantisierungskennlinie  ' ... 
         '(negativer Bereich)'])
end



function  ystr = num2bin(x,nbits)
%
%  Convert positive integer numbers to binay strings.
%  Numbers that are not whole-numbered are ignored

if sum(x < 0) > 0
  error('*** input value must not be negative')
end
ystr = [];

for ii = 1:length(x)
  z = x(ii);
  if z ~= round(z)
    str = char(32*ones(1,nbits));
  else
    str = '';
    for bb = 1:nbits
      if rem(z,2) == 0
        str = ['0' str];
        z = z/2;
      else
        str = ['1' str];
        z = (z-1)/2;
      end
    end
  end
  ystr = [ystr; str];
end
