function  ok = code_test(code,varname,nbits)
%
%  function  ok = code_test(code,varname,nbits)
%
%  Test if code words in `code` are integers within the
%  allowed range of -2^(nbits-1) ... +2^(nbits-1) 

code = code(:);   % make column vector
 
if sum((code-round(code))~=0) == 0   % are code words integer values?
  ok = 1;
                                     % are code words in 0 ... 2^nbits-1
  if sum((code < 0) | (2^nbits <= code)) > 0
    [x,ii] = sort(((code < 0) | (2^nbits <= code)) == 0);
    disp(' ');
    disp(['Fehler:  codiertes Signal ist nicht im erlaubten Bereich: ' ...
               ' 0...' num2str(2^(nbits)-1) ' !'])
    disp(['         (z.B.  ' varname '(' num2str(ii(1)) ') = ' ... 
               num2str(code(ii(1))) ')'])
    ok = 0;
  end
else
  [x,ii] = sort((code-round(code)) == 0);
  disp(' ');
  disp(['Fehler:  codiertes Signal ist nicht ganzzahlig!'])
  disp(['         (z.B.  ' varname '(' num2str(ii(1)) ') = ' ... 
                  num2str(code(ii(1))) ')'])
  ok = 0;
end    
